/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.jpa;

import cucumber.api.java.Before;
import java.util.HashMap;
import java.util.UUID;
import javax.persistence.EntityManagerFactory;
import org.apache.commons.configuration.DefaultConfigurationBuilder;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.rrt.jpa.JPARecipientRewriteTable;
import org.apache.james.rrt.jpa.model.JPARecipientRewrite;
import org.apache.james.rrt.lib.AbstractRecipientRewriteTable;
import org.apache.james.rrt.lib.RewriteTablesStepdefs;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.slf4j.LoggerFactory;

public class JPAStepdefs {
    private final RewriteTablesStepdefs mainStepdefs;

    public JPAStepdefs(RewriteTablesStepdefs mainStepdefs) {
        this.mainStepdefs = mainStepdefs;
    }

    @Before
    public void setup() throws Throwable {
        this.mainStepdefs.rewriteTable = this.getRecipientRewriteTable();
    }

    private OpenJPAEntityManagerFactory managerFactory() throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("openjpa.ConnectionDriverName", "org.h2.Driver");
        properties.put("openjpa.ConnectionURL", "jdbc:h2:target/users/" + UUID.randomUUID());
        properties.put("openjpa.Log", "JDBC=WARN, SQL=WARN, Runtime=WARN");
        properties.put("openjpa.ConnectionFactoryProperties", "PrettyPrint=true, PrettyPrintLineLength=72");
        properties.put("openjpa.jdbc.SynchronizeMappings", "buildSchema(ForeignKeys=true)");
        properties.put("openjpa.MetaDataFactory", "jpa(Types=" + JPARecipientRewrite.class.getName() + ")");
        return OpenJPAPersistence.getEntityManagerFactory(properties);
    }

    private AbstractRecipientRewriteTable getRecipientRewriteTable() throws Exception {
        JPARecipientRewriteTable localVirtualUserTable = new JPARecipientRewriteTable();
        localVirtualUserTable.setLog(LoggerFactory.getLogger((String)"MockLog"));
        localVirtualUserTable.setEntityManagerFactory((EntityManagerFactory)this.managerFactory());
        DefaultConfigurationBuilder defaultConfiguration = new DefaultConfigurationBuilder();
        localVirtualUserTable.configure((HierarchicalConfiguration)defaultConfiguration);
        return localVirtualUserTable;
    }
}

