/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.jpa;

import java.util.HashMap;
import javax.persistence.EntityManagerFactory;
import org.apache.commons.configuration.DefaultConfigurationBuilder;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.jpa.JPARecipientRewriteTable;
import org.apache.james.rrt.jpa.model.JPARecipientRewrite;
import org.apache.james.rrt.lib.AbstractRecipientRewriteTable;
import org.apache.james.rrt.lib.AbstractRecipientRewriteTableTest;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.junit.Before;
import org.slf4j.LoggerFactory;

public class JPARecipientRewriteTableTest
extends AbstractRecipientRewriteTableTest {
    private OpenJPAEntityManagerFactory factory;

    @Before
    public void setUp() throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("openjpa.ConnectionDriverName", "org.h2.Driver");
        properties.put("openjpa.ConnectionURL", "jdbc:h2:target/users/db");
        properties.put("openjpa.Log", "JDBC=WARN, SQL=WARN, Runtime=WARN");
        properties.put("openjpa.ConnectionFactoryProperties", "PrettyPrint=true, PrettyPrintLineLength=72");
        properties.put("openjpa.jdbc.SynchronizeMappings", "buildSchema(ForeignKeys=true)");
        properties.put("openjpa.MetaDataFactory", "jpa(Types=" + JPARecipientRewrite.class.getName() + ")");
        this.factory = OpenJPAPersistence.getEntityManagerFactory(properties);
        super.setUp();
    }

    protected AbstractRecipientRewriteTable getRecipientRewriteTable() throws Exception {
        JPARecipientRewriteTable localVirtualUserTable = new JPARecipientRewriteTable();
        localVirtualUserTable.setLog(LoggerFactory.getLogger((String)"MockLog"));
        localVirtualUserTable.setEntityManagerFactory((EntityManagerFactory)this.factory);
        DefaultConfigurationBuilder defaultConfiguration = new DefaultConfigurationBuilder();
        localVirtualUserTable.configure((HierarchicalConfiguration)defaultConfiguration);
        return localVirtualUserTable;
    }

    protected boolean addMapping(String user, String domain, String mapping, int type) throws RecipientRewriteTableException {
        try {
            if (type == 1) {
                this.virtualUserTable.addErrorMapping(user, domain, mapping);
            } else if (type == 0) {
                this.virtualUserTable.addRegexMapping(user, domain, mapping);
            } else if (type == 2) {
                this.virtualUserTable.addAddressMapping(user, domain, mapping);
            } else if (type == 3) {
                this.virtualUserTable.addAliasDomainMapping(domain, mapping);
            } else {
                return false;
            }
            return true;
        }
        catch (RecipientRewriteTableException e) {
            return false;
        }
    }

    protected boolean removeMapping(String user, String domain, String mapping, int type) throws RecipientRewriteTableException {
        try {
            if (type == 1) {
                this.virtualUserTable.removeErrorMapping(user, domain, mapping);
            } else if (type == 0) {
                this.virtualUserTable.removeRegexMapping(user, domain, mapping);
            } else if (type == 2) {
                this.virtualUserTable.removeAddressMapping(user, domain, mapping);
            } else if (type == 3) {
                this.virtualUserTable.removeAliasDomainMapping(domain, mapping);
            } else {
                return false;
            }
            return true;
        }
        catch (RecipientRewriteTableException e) {
            return false;
        }
    }
}

