/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.domainlist.jpa;

import java.util.HashMap;
import javax.persistence.EntityManagerFactory;
import org.apache.derby.jdbc.EmbeddedDriver;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.jpa.JPADomainList;
import org.apache.james.domainlist.jpa.model.JPADomain;
import org.apache.james.domainlist.lib.AbstractDomainListTest;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.slf4j.LoggerFactory;

public class JPADomainListTest
extends AbstractDomainListTest {
    protected DomainList createDomainList() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("openjpa.ConnectionDriverName", EmbeddedDriver.class.getName());
        properties.put("openjpa.ConnectionURL", "jdbc:derby:memory:JPADomainListTestDB;create=true");
        properties.put("openjpa.Log", "JDBC=WARN, SQL=WARN, Runtime=WARN");
        properties.put("openjpa.ConnectionFactoryProperties", "PrettyPrint=true, PrettyPrintLineLength=72");
        properties.put("openjpa.jdbc.SynchronizeMappings", "buildSchema(ForeignKeys=true)");
        properties.put("openjpa.MetaDataFactory", "jpa(Types=" + JPADomain.class.getName() + ")");
        OpenJPAEntityManagerFactory factory = OpenJPAPersistence.getEntityManagerFactory(properties);
        JPADomainList jpaDomainList = new JPADomainList();
        jpaDomainList.setLog(LoggerFactory.getLogger((String)"JPADomainListMockLog"));
        jpaDomainList.setDNSService(this.getDNSServer("localhost"));
        jpaDomainList.setAutoDetect(false);
        jpaDomainList.setAutoDetectIP(false);
        jpaDomainList.setEntityManagerFactory((EntityManagerFactory)factory);
        return jpaDomainList;
    }
}

