/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.memory.vacation;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.james.jmap.api.vacation.AccountId;
import org.apache.james.jmap.api.vacation.Vacation;
import org.apache.james.jmap.api.vacation.VacationPatch;
import org.apache.james.jmap.api.vacation.VacationRepository;

public class MemoryVacationRepository
implements VacationRepository {
    private final Map<AccountId, Vacation> vacationMap = new HashMap<AccountId, Vacation>();

    @Override
    public CompletableFuture<Vacation> retrieveVacation(AccountId accountId) {
        Preconditions.checkNotNull((Object)accountId);
        return CompletableFuture.completedFuture(this.vacationMap.getOrDefault(accountId, DEFAULT_VACATION));
    }

    @Override
    public CompletableFuture<Void> modifyVacation(AccountId accountId, VacationPatch vacationPatch) {
        Preconditions.checkNotNull((Object)accountId);
        Preconditions.checkNotNull((Object)vacationPatch);
        Vacation oldVacation = this.retrieveVacation(accountId).join();
        this.vacationMap.put(accountId, vacationPatch.patch(oldVacation));
        return CompletableFuture.completedFuture(null);
    }
}

