/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.memory.vacation;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import org.apache.james.jmap.api.vacation.AccountId;
import org.apache.james.jmap.api.vacation.NotificationRegistry;
import org.apache.james.jmap.api.vacation.RecipientId;
import org.apache.james.util.date.ZonedDateTimeProvider;

public class MemoryNotificationRegistry
implements NotificationRegistry {
    private final ZonedDateTimeProvider zonedDateTimeProvider;
    private final Multimap<AccountId, Entry> registrations;

    @Inject
    public MemoryNotificationRegistry(ZonedDateTimeProvider zonedDateTimeProvider) {
        this.zonedDateTimeProvider = zonedDateTimeProvider;
        this.registrations = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
    }

    @Override
    public CompletableFuture<Void> register(AccountId accountId, RecipientId recipientId, Optional<ZonedDateTime> expiryDate) {
        this.registrations.put((Object)accountId, (Object)new Entry(recipientId, expiryDate));
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Boolean> isRegistered(AccountId accountId, RecipientId recipientId) {
        ZonedDateTime currentTime = (ZonedDateTime)this.zonedDateTimeProvider.get();
        return CompletableFuture.completedFuture(this.registrations.get((Object)accountId).stream().filter(entry -> entry.getRecipientId().equals(recipientId)).map(Entry::getExpiryDate).findAny().filter(optional -> optional.map(registrationEnd -> this.isStrictlyBefore(currentTime, (ZonedDateTime)registrationEnd)).orElse(true)).isPresent());
    }

    private boolean isStrictlyBefore(ZonedDateTime currentTime, ZonedDateTime registrationEnd) {
        return !currentTime.isAfter(registrationEnd);
    }

    @Override
    public CompletableFuture<Void> flush(AccountId accountId) {
        this.registrations.removeAll((Object)accountId);
        return CompletableFuture.completedFuture(null);
    }

    public static class Entry {
        private final RecipientId recipientId;
        private final Optional<ZonedDateTime> expiryDate;

        public Entry(RecipientId recipientId, Optional<ZonedDateTime> expiryDate) {
            this.recipientId = recipientId;
            this.expiryDate = expiryDate;
        }

        public RecipientId getRecipientId() {
            return this.recipientId;
        }

        public Optional<ZonedDateTime> getExpiryDate() {
            return this.expiryDate;
        }
    }
}

