/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.memory.access;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.collections4.map.PassiveExpiringMap;
import org.apache.james.jmap.api.access.AccessToken;
import org.apache.james.jmap.api.access.AccessTokenRepository;
import org.apache.james.jmap.api.access.exceptions.InvalidAccessToken;

public class MemoryAccessTokenRepository
implements AccessTokenRepository {
    private final PassiveExpiringMap<AccessToken, String> tokensExpirationDates;

    @Inject
    public MemoryAccessTokenRepository(@Named(value="tokenExpirationInMs") long durationInMilliseconds) {
        this.tokensExpirationDates = new PassiveExpiringMap(durationInMilliseconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> addToken(String username, AccessToken accessToken) {
        Preconditions.checkNotNull((Object)username);
        Preconditions.checkArgument((!username.isEmpty() ? 1 : 0) != 0, (Object)"Username should not be empty");
        Preconditions.checkNotNull((Object)accessToken);
        PassiveExpiringMap<AccessToken, String> passiveExpiringMap = this.tokensExpirationDates;
        synchronized (passiveExpiringMap) {
            this.tokensExpirationDates.put((Object)accessToken, (Object)username);
        }
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> removeToken(AccessToken accessToken) {
        Preconditions.checkNotNull((Object)accessToken);
        PassiveExpiringMap<AccessToken, String> passiveExpiringMap = this.tokensExpirationDates;
        synchronized (passiveExpiringMap) {
            this.tokensExpirationDates.remove((Object)accessToken);
        }
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<String> getUsernameFromToken(AccessToken accessToken) throws InvalidAccessToken {
        Preconditions.checkNotNull((Object)accessToken);
        PassiveExpiringMap<AccessToken, String> passiveExpiringMap = this.tokensExpirationDates;
        synchronized (passiveExpiringMap) {
            return CompletableFuture.completedFuture(Optional.ofNullable(this.tokensExpirationDates.get((Object)accessToken)).orElseThrow(() -> new CompletionException(new InvalidAccessToken(accessToken))));
        }
    }
}

