/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.api.access;

import java.util.Objects;
import java.util.UUID;
import org.apache.james.jmap.api.access.exceptions.NotAnAccessTokenException;

public class AccessToken {
    private final UUID token;

    public static AccessToken fromString(String tokenString) throws NotAnAccessTokenException {
        try {
            return new AccessToken(UUID.fromString(tokenString));
        }
        catch (IllegalArgumentException e) {
            throw new NotAnAccessTokenException(e);
        }
    }

    private AccessToken(UUID token) {
        this.token = token;
    }

    public static AccessToken generate() {
        return new AccessToken(UUID.randomUUID());
    }

    public String serialize() {
        return this.token.toString();
    }

    public UUID asUUID() {
        return this.token;
    }

    public boolean equals(Object o) {
        return o != null && o instanceof AccessToken && Objects.equals(this.token, ((AccessToken)o).token);
    }

    public int hashCode() {
        return Objects.hash(this.token);
    }
}

