/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.cassandra.vacation;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.apache.james.jmap.api.model.AccountId;
import org.apache.james.jmap.api.vacation.Vacation;
import org.apache.james.jmap.api.vacation.VacationPatch;
import org.apache.james.jmap.api.vacation.VacationRepository;
import org.apache.james.jmap.cassandra.vacation.CassandraVacationDAO;
import reactor.core.publisher.Mono;

public class CassandraVacationRepository
implements VacationRepository {
    private final CassandraVacationDAO cassandraVacationDAO;

    @Inject
    public CassandraVacationRepository(CassandraVacationDAO cassandraVacationDAO) {
        this.cassandraVacationDAO = cassandraVacationDAO;
    }

    public Mono<Void> modifyVacation(AccountId accountId, VacationPatch vacationPatch) {
        Preconditions.checkNotNull((Object)accountId);
        Preconditions.checkNotNull((Object)vacationPatch);
        if (vacationPatch.isIdentity()) {
            return Mono.empty();
        }
        return this.cassandraVacationDAO.modifyVacation(accountId, vacationPatch);
    }

    public Mono<Vacation> retrieveVacation(AccountId accountId) {
        return this.cassandraVacationDAO.retrieveVacation(accountId).map(optional -> optional.orElse(DEFAULT_VACATION));
    }
}

