/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.cassandra.projections;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.schemabuilder.Create;
import com.datastax.driver.core.schemabuilder.SchemaBuilder;
import org.apache.james.backends.cassandra.components.CassandraModule;

public interface CassandraEmailQueryViewModule {
    public static final CassandraModule MODULE = CassandraModule.table((String)"email_query_view_sent_at").comment("Storing the JMAP projections for list of emails within a mailbox to not rely on ElasticSearch for basic Email/query (sorts sentAt).").options(options -> (Create.Options)options.clusteringOrder("sentAt", SchemaBuilder.Direction.DESC).caching(SchemaBuilder.KeyCaching.ALL, SchemaBuilder.rows((int)10))).statement(statement -> statement.addPartitionKey("mailboxId", DataType.uuid()).addClusteringColumn("sentAt", DataType.timestamp()).addClusteringColumn("messageId", DataType.uuid())).table("email_query_view_received_at").comment("Storing the JMAP projections for list of emails within a mailbox to not rely on ElasticSearch for basic Email/query (sorts and filter on receivedAt).").options(options -> (Create.Options)options.clusteringOrder("receivedAt", SchemaBuilder.Direction.DESC).caching(SchemaBuilder.KeyCaching.ALL, SchemaBuilder.rows((int)10))).statement(statement -> (Create)statement.addPartitionKey("mailboxId", DataType.uuid()).addClusteringColumn("receivedAt", DataType.timestamp()).addClusteringColumn("messageId", DataType.uuid()).addColumn("sentAt", DataType.timestamp())).table("email_query_view_date_lookup").comment("Given a MailboxId+MessageId lookup the dates of a message to delete it.").options(options -> (Create.Options)options.caching(SchemaBuilder.KeyCaching.ALL, SchemaBuilder.rows((int)10))).statement(statement -> (Create)((Create)statement.addPartitionKey("mailboxId", DataType.uuid()).addClusteringColumn("messageId", DataType.uuid()).addColumn("sentAt", DataType.timestamp())).addColumn("receivedAt", DataType.timestamp())).build();
}

