/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.cassandra.change;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.stream.Collector;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.james.jmap.api.change.EmailChange;
import org.apache.james.jmap.api.change.EmailChangeRepository;
import org.apache.james.jmap.api.change.EmailChanges;
import org.apache.james.jmap.api.change.Limit;
import org.apache.james.jmap.api.change.State;
import org.apache.james.jmap.api.exception.ChangeNotFoundException;
import org.apache.james.jmap.api.model.AccountId;
import org.apache.james.jmap.cassandra.change.EmailChangeRepositoryDAO;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraEmailChangeRepository
implements EmailChangeRepository {
    public static final String LIMIT_NAME = "emailChangeDefaultLimit";
    private final EmailChangeRepositoryDAO emailChangeRepositoryDAO;
    private final Limit defaultLimit;

    @Inject
    public CassandraEmailChangeRepository(EmailChangeRepositoryDAO emailChangeRepositoryDAO, @Named(value="emailChangeDefaultLimit") Limit defaultLimit) {
        this.emailChangeRepositoryDAO = emailChangeRepositoryDAO;
        this.defaultLimit = defaultLimit;
    }

    public Mono<Void> save(EmailChange change) {
        return this.emailChangeRepositoryDAO.insert(change);
    }

    public Mono<EmailChanges> getSinceState(AccountId accountId, State state, Optional<Limit> maxChanges) {
        Preconditions.checkNotNull((Object)accountId);
        Preconditions.checkNotNull((Object)state);
        maxChanges.ifPresent(limit -> Preconditions.checkArgument((limit.getValue() > 0 ? 1 : 0) != 0, (Object)"maxChanges must be a positive integer"));
        if (state.equals((Object)State.INITIAL)) {
            return this.emailChangeRepositoryDAO.getAllChanges(accountId).filter(change -> !change.isDelegated()).collect((Collector)new EmailChanges.Builder.EmailChangeCollector(state, maxChanges.orElse(this.defaultLimit)));
        }
        return this.emailChangeRepositoryDAO.getChangesSince(accountId, state).switchIfEmpty((Publisher)Flux.error((Throwable)new ChangeNotFoundException(state, String.format("State '%s' could not be found", state.getValue())))).filter(change -> !change.isDelegated()).filter(change -> !change.getState().equals((Object)state)).collect((Collector)new EmailChanges.Builder.EmailChangeCollector(state, maxChanges.orElse(this.defaultLimit)));
    }

    public Mono<EmailChanges> getSinceStateWithDelegation(AccountId accountId, State state, Optional<Limit> maxChanges) {
        Preconditions.checkNotNull((Object)accountId);
        Preconditions.checkNotNull((Object)state);
        maxChanges.ifPresent(limit -> Preconditions.checkArgument((limit.getValue() > 0 ? 1 : 0) != 0, (Object)"maxChanges must be a positive integer"));
        if (state.equals((Object)State.INITIAL)) {
            return this.emailChangeRepositoryDAO.getAllChanges(accountId).collect((Collector)new EmailChanges.Builder.EmailChangeCollector(state, maxChanges.orElse(this.defaultLimit)));
        }
        return this.emailChangeRepositoryDAO.getChangesSince(accountId, state).switchIfEmpty((Publisher)Flux.error((Throwable)new ChangeNotFoundException(state, String.format("State '%s' could not be found", state.getValue())))).filter(change -> !change.getState().equals((Object)state)).collect((Collector)new EmailChanges.Builder.EmailChangeCollector(state, maxChanges.orElse(this.defaultLimit)));
    }

    public Mono<State> getLatestState(AccountId accountId) {
        return this.emailChangeRepositoryDAO.latestStateNotDelegated(accountId).switchIfEmpty(Mono.just((Object)State.INITIAL));
    }

    public Mono<State> getLatestStateWithDelegation(AccountId accountId) {
        return this.emailChangeRepositoryDAO.latestState(accountId).switchIfEmpty(Mono.just((Object)State.INITIAL));
    }
}

