/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.cassandra.vacation;

import org.apache.james.backends.cassandra.CassandraCluster;
import org.apache.james.backends.cassandra.DockerCassandraRule;
import org.apache.james.backends.cassandra.components.CassandraModule;
import org.apache.james.jmap.api.vacation.AbstractNotificationRegistryTest;
import org.apache.james.jmap.api.vacation.NotificationRegistry;
import org.apache.james.jmap.cassandra.vacation.CassandraNotificationRegistry;
import org.apache.james.jmap.cassandra.vacation.CassandraNotificationRegistryDAO;
import org.apache.james.jmap.cassandra.vacation.CassandraNotificationRegistryModule;
import org.apache.james.util.Host;
import org.apache.james.util.date.ZonedDateTimeProvider;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;

public class CassandraNotificationRegistryTest
extends AbstractNotificationRegistryTest {
    @ClassRule
    public static DockerCassandraRule cassandraServer = new DockerCassandraRule();
    private static CassandraCluster cassandra;

    @BeforeClass
    public static void setUpClass() {
        cassandra = CassandraCluster.create((CassandraModule)CassandraNotificationRegistryModule.MODULE, (Host)cassandraServer.getHost());
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @After
    public void tearDown() {
        cassandra.clearTables();
    }

    @AfterClass
    public static void tearDownClass() {
        cassandra.closeCluster();
    }

    protected NotificationRegistry createNotificationRegistry(ZonedDateTimeProvider zonedDateTimeProvider) {
        return new CassandraNotificationRegistry(zonedDateTimeProvider, new CassandraNotificationRegistryDAO(cassandra.getConf()));
    }
}

