/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.cassandra.filtering;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.google.common.collect.ImmutableList;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import org.apache.james.core.User;
import org.apache.james.eventsourcing.EventId;
import org.apache.james.jmap.api.filtering.RuleFixture;
import org.apache.james.jmap.api.filtering.impl.FilteringAggregateId;
import org.apache.james.jmap.api.filtering.impl.RuleSetDefined;
import org.apache.james.jmap.cassandra.filtering.FilteringRuleSetDefinedDTO;
import org.apache.james.util.ClassLoaderUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DTOTest {
    static final String EVENT_JSON = ClassLoaderUtils.getSystemResourceAsString((String)"json/event.json");
    static final String EVENT_EMPTY_JSON = ClassLoaderUtils.getSystemResourceAsString((String)"json/eventEmpty.json");
    static final String EVENT_COMPLEX_JSON = ClassLoaderUtils.getSystemResourceAsString((String)"json/eventComplex.json");
    static final FilteringRuleSetDefinedDTO SIMPLE_DTO = FilteringRuleSetDefinedDTO.from((RuleSetDefined)new RuleSetDefined(new FilteringAggregateId(User.fromUsername((String)"Bart")), EventId.first(), ImmutableList.of((Object)RuleFixture.RULE_1, (Object)RuleFixture.RULE_2)));
    static final FilteringRuleSetDefinedDTO EMPTY_DTO = FilteringRuleSetDefinedDTO.from((RuleSetDefined)new RuleSetDefined(new FilteringAggregateId(User.fromUsername((String)"Bart")), EventId.first(), ImmutableList.of()));
    static final FilteringRuleSetDefinedDTO COMPLEX_DTO = FilteringRuleSetDefinedDTO.from((RuleSetDefined)new RuleSetDefined(new FilteringAggregateId(User.fromUsername((String)"Bart")), EventId.first(), ImmutableList.of((Object)RuleFixture.RULE_FROM, (Object)RuleFixture.RULE_RECIPIENT, (Object)RuleFixture.RULE_SUBJECT, (Object)RuleFixture.RULE_TO)));
    private ObjectMapper objectMapper;

    @BeforeEach
    void setUp() {
        this.objectMapper = new ObjectMapper();
        this.objectMapper.registerModule((Module)new Jdk8Module());
        this.objectMapper.registerModule((Module)new GuavaModule());
    }

    @Test
    void shouldSerializeDTO() throws Exception {
        String serializedEvent = this.objectMapper.writeValueAsString((Object)SIMPLE_DTO);
        JsonAssertions.assertThatJson((Object)serializedEvent).isEqualTo((Object)EVENT_JSON);
    }

    @Test
    void shouldDeserializeDTO() throws Exception {
        FilteringRuleSetDefinedDTO dto = (FilteringRuleSetDefinedDTO)this.objectMapper.readValue(EVENT_JSON, FilteringRuleSetDefinedDTO.class);
        Assertions.assertThat((Object)dto).isEqualTo((Object)SIMPLE_DTO);
    }

    @Test
    void shouldSerializeEmptyDTO() throws Exception {
        String serializedEvent = this.objectMapper.writeValueAsString((Object)EMPTY_DTO);
        JsonAssertions.assertThatJson((Object)serializedEvent).isEqualTo((Object)EVENT_EMPTY_JSON);
    }

    @Test
    void shouldDeserializeEmptyDTO() throws Exception {
        FilteringRuleSetDefinedDTO dto = (FilteringRuleSetDefinedDTO)this.objectMapper.readValue(EVENT_EMPTY_JSON, FilteringRuleSetDefinedDTO.class);
        Assertions.assertThat((Object)dto).isEqualTo((Object)EMPTY_DTO);
    }

    @Test
    void shouldSerializeComplexDTO() throws Exception {
        String serializedEvent = this.objectMapper.writeValueAsString((Object)COMPLEX_DTO);
        JsonAssertions.assertThatJson((Object)serializedEvent).isEqualTo((Object)EVENT_COMPLEX_JSON);
    }

    @Test
    void shouldDeserializeComplexDTO() throws Exception {
        FilteringRuleSetDefinedDTO dto = (FilteringRuleSetDefinedDTO)this.objectMapper.readValue(EVENT_COMPLEX_JSON, FilteringRuleSetDefinedDTO.class);
        Assertions.assertThat((Object)dto).isEqualTo((Object)COMPLEX_DTO);
    }
}

