/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.cassandra.access;

import org.apache.james.backends.cassandra.CassandraCluster;
import org.apache.james.backends.cassandra.DockerCassandraRule;
import org.apache.james.backends.cassandra.components.CassandraModule;
import org.apache.james.jmap.api.access.AccessTokenRepository;
import org.apache.james.jmap.api.access.AccessTokenRepositoryTest;
import org.apache.james.jmap.cassandra.access.CassandraAccessModule;
import org.apache.james.jmap.cassandra.access.CassandraAccessTokenDAO;
import org.apache.james.jmap.cassandra.access.CassandraAccessTokenRepository;
import org.apache.james.util.Host;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;

public class CassandraAccessTokenRepositoryTest
extends AccessTokenRepositoryTest {
    @ClassRule
    public static DockerCassandraRule cassandraServer = new DockerCassandraRule();
    private static CassandraCluster cassandra;

    @BeforeClass
    public static void setUpClass() {
        cassandra = CassandraCluster.create((CassandraModule)CassandraAccessModule.MODULE, (Host)cassandraServer.getHost());
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @After
    public void tearDown() {
        cassandra.clearTables();
    }

    @AfterClass
    public static void tearDownClass() {
        cassandra.closeCluster();
    }

    protected AccessTokenRepository provideAccessTokenRepository() {
        return new CassandraAccessTokenRepository(new CassandraAccessTokenDAO(cassandra.getConf(), 1000L));
    }
}

