/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.cassandra.vacation;

import com.google.common.base.Preconditions;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import org.apache.james.jmap.api.vacation.AccountId;
import org.apache.james.jmap.api.vacation.Vacation;
import org.apache.james.jmap.api.vacation.VacationPatch;
import org.apache.james.jmap.api.vacation.VacationRepository;
import org.apache.james.jmap.cassandra.vacation.CassandraVacationDAO;

public class CassandraVacationRepository
implements VacationRepository {
    private final CassandraVacationDAO cassandraVacationDAO;

    @Inject
    public CassandraVacationRepository(CassandraVacationDAO cassandraVacationDAO) {
        this.cassandraVacationDAO = cassandraVacationDAO;
    }

    public CompletableFuture<Void> modifyVacation(AccountId accountId, VacationPatch vacationPatch) {
        Preconditions.checkNotNull((Object)accountId);
        Preconditions.checkNotNull((Object)vacationPatch);
        if (vacationPatch.isIdentity()) {
            return CompletableFuture.completedFuture(null);
        }
        return this.cassandraVacationDAO.modifyVacation(accountId, vacationPatch);
    }

    public CompletableFuture<Vacation> retrieveVacation(AccountId accountId) {
        return this.cassandraVacationDAO.retrieveVacation(accountId).thenApply(optional -> optional.orElse(DEFAULT_VACATION));
    }
}

