/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.cassandra.vacation;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.BindMarker;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.jmap.api.vacation.AccountId;
import org.apache.james.jmap.api.vacation.RecipientId;

public class CassandraNotificationRegistryDAO {
    public static final String TTL = "TTL";
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final PreparedStatement registerStatement;
    private final PreparedStatement registerWithTTLStatement;
    private final PreparedStatement isRegisteredStatement;
    private final PreparedStatement flushStatement;

    @Inject
    public CassandraNotificationRegistryDAO(Session session) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.registerStatement = session.prepare((RegularStatement)this.createInsert());
        this.registerWithTTLStatement = session.prepare((RegularStatement)this.createInsert().using(QueryBuilder.ttl((BindMarker)QueryBuilder.bindMarker((String)TTL))));
        this.isRegisteredStatement = session.prepare((RegularStatement)QueryBuilder.select().from("vacation_notification_registry").where(QueryBuilder.eq((String)"accountId", (Object)QueryBuilder.bindMarker((String)"accountId"))).and(QueryBuilder.eq((String)"recipientId", (Object)QueryBuilder.bindMarker((String)"recipientId"))));
        this.flushStatement = session.prepare((RegularStatement)QueryBuilder.delete().from("vacation_notification_registry").where(QueryBuilder.eq((String)"accountId", (Object)QueryBuilder.bindMarker((String)"accountId"))));
    }

    private Insert createInsert() {
        return QueryBuilder.insertInto((String)"vacation_notification_registry").value("accountId", (Object)QueryBuilder.bindMarker((String)"accountId")).value("recipientId", (Object)QueryBuilder.bindMarker((String)"recipientId"));
    }

    public CompletableFuture<Void> register(AccountId accountId, RecipientId recipientId, Optional<Integer> ttl) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)ttl.map(value -> this.registerWithTTLStatement.bind().setInt(TTL, value.intValue())).orElse(this.registerStatement.bind()).setString("accountId", accountId.getIdentifier()).setString("recipientId", recipientId.getAsString()));
    }

    public CompletableFuture<Boolean> isRegistered(AccountId accountId, RecipientId recipientId) {
        return this.cassandraAsyncExecutor.executeSingleRow((Statement)this.isRegisteredStatement.bind().setString("accountId", accountId.getIdentifier()).setString("recipientId", recipientId.getAsString())).thenApply(Optional::isPresent);
    }

    public CompletableFuture<Void> flush(AccountId accountId) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.flushStatement.bind().setString("accountId", accountId.getIdentifier()));
    }
}

