/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.cassandra.access;

import com.google.common.base.Preconditions;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import org.apache.james.jmap.api.access.AccessToken;
import org.apache.james.jmap.api.access.AccessTokenRepository;
import org.apache.james.jmap.api.access.exceptions.InvalidAccessToken;
import org.apache.james.jmap.cassandra.access.CassandraAccessTokenDAO;

public class CassandraAccessTokenRepository
implements AccessTokenRepository {
    private final CassandraAccessTokenDAO cassandraAccessTokenDAO;

    @Inject
    public CassandraAccessTokenRepository(CassandraAccessTokenDAO cassandraAccessTokenDAO) {
        this.cassandraAccessTokenDAO = cassandraAccessTokenDAO;
    }

    public CompletableFuture<Void> addToken(String username, AccessToken accessToken) {
        Preconditions.checkNotNull((Object)username);
        Preconditions.checkArgument((!username.isEmpty() ? 1 : 0) != 0, (Object)"Username should not be empty");
        Preconditions.checkNotNull((Object)accessToken);
        return this.cassandraAccessTokenDAO.addToken(username, accessToken);
    }

    public CompletableFuture<Void> removeToken(AccessToken accessToken) {
        Preconditions.checkNotNull((Object)accessToken);
        return this.cassandraAccessTokenDAO.removeToken(accessToken);
    }

    public CompletableFuture<String> getUsernameFromToken(AccessToken accessToken) throws InvalidAccessToken {
        Preconditions.checkNotNull((Object)accessToken);
        return this.cassandraAccessTokenDAO.getUsernameFromToken(accessToken).thenApply(optional -> (String)optional.orElseThrow(() -> new InvalidAccessToken(accessToken)));
    }
}

