/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.cassandra.access;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.BindMarker;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.google.common.primitives.Ints;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.jmap.api.access.AccessToken;

public class CassandraAccessTokenDAO {
    private static final String TTL = "ttl";
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final PreparedStatement removeStatement;
    private final PreparedStatement insertStatement;
    private final PreparedStatement selectStatement;
    private final int durationInSeconds;

    @Inject
    public CassandraAccessTokenDAO(Session session, @Named(value="tokenExpirationInMs") long durationInMilliseconds) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.durationInSeconds = Ints.checkedCast((long)TimeUnit.MILLISECONDS.toSeconds(durationInMilliseconds));
        this.removeStatement = session.prepare((RegularStatement)QueryBuilder.delete().from("access_token").where(QueryBuilder.eq((String)"access_token", (Object)QueryBuilder.bindMarker((String)"access_token"))));
        this.insertStatement = session.prepare((RegularStatement)QueryBuilder.insertInto((String)"access_token").value("access_token", (Object)QueryBuilder.bindMarker((String)"access_token")).value("username", (Object)QueryBuilder.bindMarker((String)"username")).using(QueryBuilder.ttl((BindMarker)QueryBuilder.bindMarker((String)TTL))));
        this.selectStatement = session.prepare((RegularStatement)QueryBuilder.select().from("access_token").where(QueryBuilder.eq((String)"access_token", (Object)QueryBuilder.bindMarker((String)"access_token"))));
    }

    public CompletableFuture<Void> addToken(String username, AccessToken accessToken) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.insertStatement.bind().setUUID("access_token", accessToken.asUUID()).setString("username", username).setInt(TTL, this.durationInSeconds));
    }

    public CompletableFuture<Void> removeToken(AccessToken accessToken) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.removeStatement.bind().setUUID("access_token", accessToken.asUUID()));
    }

    public CompletableFuture<Optional<String>> getUsernameFromToken(AccessToken accessToken) {
        return this.cassandraAsyncExecutor.executeSingleRow((Statement)this.selectStatement.bind().setUUID("access_token", accessToken.asUUID())).thenApply(optional -> optional.map(row -> row.getString("username")));
    }
}

