/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.jdbc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.james.repository.api.StreamRepository;
import org.apache.james.server.core.MimeMessageCopyOnWriteProxy;
import org.apache.james.server.core.MimeMessageUtil;
import org.apache.james.server.core.MimeMessageWrapper;
import org.apache.mailet.Mail;

final class MessageInputStream
extends InputStream {
    private long size = -1L;
    private InputStream wrapped;
    private Exception caughtException = null;
    private final StreamRepository streamRep;

    public MessageInputStream(Mail mc, StreamRepository srep, int sizeLimit, final boolean update) throws IOException, MessagingException {
        this.streamRep = srep;
        this.size = mc.getMessageSize();
        if (this.streamRep == null && this.size > (long)sizeLimit) {
            PipedOutputStream headerOut = new PipedOutputStream();
            new Thread(){
                private Mail mail;
                private PipedOutputStream out;

                @Override
                public void run() {
                    try {
                        MessageInputStream.this.writeStream(this.mail, this.out, update);
                    }
                    catch (IOException | MessagingException e) {
                        MessageInputStream.this.caughtException = (Exception)e;
                    }
                }

                public Thread setParam(Mail mc, PipedOutputStream headerOut) {
                    this.mail = mc;
                    this.out = headerOut;
                    return this;
                }
            }.setParam(mc, headerOut).start();
            this.wrapped = new PipedInputStream(headerOut);
        } else {
            ByteArrayOutputStream headerOut = new ByteArrayOutputStream();
            this.writeStream(mc, headerOut, update);
            this.wrapped = new ByteArrayInputStream(headerOut.toByteArray());
            this.size = headerOut.size();
        }
    }

    public long getSize() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStream(Mail mail, OutputStream out, boolean update) throws IOException, MessagingException {
        MimeMessage msg = mail.getMessage();
        if (update) {
            if (msg instanceof MimeMessageCopyOnWriteProxy) {
                msg = ((MimeMessageCopyOnWriteProxy)msg).getWrappedMessage();
            }
            if (msg instanceof MimeMessageWrapper) {
                MimeMessageWrapper wrapper = (MimeMessageWrapper)msg;
                wrapper.loadMessage();
            }
        }
        OutputStream bodyOut = null;
        try {
            bodyOut = this.streamRep == null ? out : this.streamRep.put(mail.getName());
            if (msg instanceof MimeMessageWrapper) {
                ((MimeMessageWrapper)msg).writeTo(out, bodyOut, null, true);
            } else {
                MimeMessageUtil.writeTo((MimeMessage)mail.getMessage(), (OutputStream)out, (OutputStream)bodyOut);
            }
            out.flush();
            bodyOut.flush();
        }
        finally {
            this.closeOutputStreams(out, bodyOut);
        }
    }

    private void throwException() throws IOException {
        try {
            if (this.wrapped == null) {
                throw new IOException("wrapped stream does not exists anymore");
            }
            if (this.caughtException instanceof IOException) {
                throw (IOException)this.caughtException;
            }
            throw new IOException("Exception caugth in worker thread " + this.caughtException.getMessage()){

                @Override
                public Throwable getCause() {
                    return MessageInputStream.this.caughtException;
                }
            };
        }
        catch (Throwable throwable) {
            this.caughtException = null;
            this.wrapped = null;
            throw throwable;
        }
    }

    private void closeOutputStreams(OutputStream headerStream, OutputStream bodyStream) throws IOException {
        try {
            if (headerStream != null && headerStream != bodyStream) {
                headerStream.close();
            }
        }
        finally {
            if (bodyStream != null) {
                bodyStream.close();
            }
        }
    }

    @Override
    public int available() throws IOException {
        if (this.caughtException != null || this.wrapped == null) {
            this.throwException();
        }
        return this.wrapped.available();
    }

    @Override
    public void close() throws IOException {
        if (this.caughtException != null || this.wrapped == null) {
            this.throwException();
        }
        this.wrapped.close();
        this.wrapped = null;
    }

    @Override
    public synchronized void mark(int readLimit) {
        this.wrapped.mark(readLimit);
    }

    @Override
    public boolean markSupported() {
        return this.wrapped.markSupported();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.caughtException != null || this.wrapped == null) {
            this.throwException();
        }
        return this.wrapped.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (this.caughtException != null || this.wrapped == null) {
            this.throwException();
        }
        return this.wrapped.read(b);
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.caughtException != null || this.wrapped == null) {
            this.throwException();
        }
        this.wrapped.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.caughtException != null || this.wrapped == null) {
            this.throwException();
        }
        return this.wrapped.skip(n);
    }

    @Override
    public int read() throws IOException {
        if (this.caughtException != null || this.wrapped == null) {
            this.throwException();
        }
        return this.wrapped.read();
    }
}

