/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.jdbc;

import java.util.Iterator;
import javax.sql.DataSource;
import org.apache.commons.configuration.DefaultConfigurationBuilder;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.derby.jdbc.EmbeddedDriver;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.filesystem.api.mock.MockFileSystem;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.user.jdbc.AbstractJdbcUsersRepository;
import org.apache.james.user.jdbc.AbstractUsersJdbcRepositoryTest;
import org.apache.james.user.jdbc.DefaultUsersJdbcRepository;
import org.apache.james.user.lib.AbstractUsersRepository;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;

public class DefaultUsersJdbcRepositoryTest
extends AbstractUsersJdbcRepositoryTest {
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    protected AbstractUsersRepository getUsersRepository() throws Exception {
        DefaultUsersJdbcRepository res = new DefaultUsersJdbcRepository();
        String tableString = "defusers";
        this.configureAbstractJdbcUsersRepository((AbstractJdbcUsersRepository)res, tableString);
        return res;
    }

    protected void configureAbstractJdbcUsersRepository(AbstractJdbcUsersRepository res, String tableString) throws Exception {
        res.setFileSystem((FileSystem)new MockFileSystem());
        BasicDataSource dataSource = this.getDataSource();
        res.setDatasource((DataSource)dataSource);
        DefaultConfigurationBuilder configuration = new DefaultConfigurationBuilder();
        configuration.addProperty("[@destinationURL]", (Object)("db://maildb/" + tableString));
        configuration.addProperty("sqlFile", (Object)"file://conf/sqlResources.xml");
        res.configure((HierarchicalConfiguration)configuration);
        res.init();
    }

    private BasicDataSource getDataSource() {
        BasicDataSource ds = new BasicDataSource();
        ds.setDriverClassName(EmbeddedDriver.class.getName());
        ds.setUrl("jdbc:derby:memory:testdb;create=true");
        ds.setUsername("james");
        ds.setPassword("james");
        return ds;
    }

    protected void disposeUsersRepository() throws UsersRepositoryException {
        Iterator i = this.usersRepository.list();
        while (i.hasNext()) {
            this.usersRepository.removeUser((String)i.next());
        }
        LifecycleUtil.dispose((Object)this.usersRepository);
    }

    @Ignore
    public void testShouldReturnTrueWhenAUserHasACorrectPasswordAndOtherCaseInDomain() throws Exception {
    }
}

