/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.jdbc;

import cucumber.api.java.Before;
import java.util.UUID;
import javax.sql.DataSource;
import org.apache.commons.configuration.DefaultConfigurationBuilder;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.derby.jdbc.EmbeddedDriver;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.filesystem.api.mock.MockFileSystem;
import org.apache.james.rrt.jdbc.JDBCRecipientRewriteTable;
import org.apache.james.rrt.lib.AbstractRecipientRewriteTable;
import org.apache.james.rrt.lib.RewriteTablesStepdefs;

public class JDBCStepdefs {
    private final RewriteTablesStepdefs mainStepdefs;

    public JDBCStepdefs(RewriteTablesStepdefs mainStepdefs) {
        this.mainStepdefs = mainStepdefs;
    }

    @Before
    public void setup() throws Throwable {
        this.mainStepdefs.rewriteTable = this.getRecipientRewriteTable();
    }

    protected AbstractRecipientRewriteTable getRecipientRewriteTable() throws Exception {
        JDBCRecipientRewriteTable localVirtualUserTable = new JDBCRecipientRewriteTable();
        localVirtualUserTable.setDataSource((DataSource)this.getDataSource());
        localVirtualUserTable.setFileSystem((FileSystem)new MockFileSystem());
        DefaultConfigurationBuilder defaultConfiguration = new DefaultConfigurationBuilder();
        defaultConfiguration.addProperty("[@destinationURL]", (Object)"db://maildb/RecipientRewriteTable");
        defaultConfiguration.addProperty("sqlFile", (Object)"file://conf/sqlResources.xml");
        localVirtualUserTable.configure((HierarchicalConfiguration)defaultConfiguration);
        localVirtualUserTable.init();
        return localVirtualUserTable;
    }

    private BasicDataSource getDataSource() {
        BasicDataSource ds = new BasicDataSource();
        ds.setDriverClassName(EmbeddedDriver.class.getName());
        ds.setUrl("jdbc:derby:target/" + UUID.randomUUID() + ";create=true");
        ds.setUsername("james");
        ds.setPassword("james");
        return ds;
    }
}

