/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.jdbc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.sql.DataSource;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.DefaultConfigurationBuilder;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.core.MailAddress;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.mailrepository.api.MailKey;
import org.apache.james.mailrepository.jdbc.MessageInputStream;
import org.apache.james.mailrepository.jdbc.MimeMessageJDBCSource;
import org.apache.james.mailrepository.lib.AbstractMailRepository;
import org.apache.james.repository.api.StreamRepository;
import org.apache.james.repository.file.FilePersistentStreamRepository;
import org.apache.james.server.core.MailImpl;
import org.apache.james.server.core.MimeMessageCopyOnWriteProxy;
import org.apache.james.server.core.MimeMessageSource;
import org.apache.james.server.core.MimeMessageWrapper;
import org.apache.james.util.sql.JDBCUtil;
import org.apache.james.util.sql.SqlResources;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCMailRepository
extends AbstractMailRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(JDBCMailRepository.class);
    protected String tableName;
    protected String repositoryName;
    private String sqlFileName;
    private FilePersistentStreamRepository sr = null;
    protected DataSource datasource;
    protected String datasourceName;
    protected SqlResources sqlQueries;
    protected JDBCUtil theJDBCUtil;
    protected boolean jdbcMailAttributesReady = false;
    private int inMemorySizeLimit;
    private FileSystem fileSystem;
    private String filestore;
    private String destination;

    @Inject
    public void setDatasource(DataSource datasource) {
        this.datasource = datasource;
    }

    @Inject
    public void setFileSystem(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    protected void doConfigure(HierarchicalConfiguration configuration) throws ConfigurationException {
        super.doConfigure(configuration);
        LOGGER.debug("{}.configure()", (Object)((Object)((Object)this)).getClass().getName());
        this.destination = configuration.getString("[@destinationURL]");
        if (!this.destination.endsWith("/")) {
            this.destination = this.destination + "/";
        }
        ArrayList<String> urlParams = new ArrayList<String>();
        int start = 5;
        if (this.destination.startsWith("dbfile")) {
            start += 4;
        }
        int end = this.destination.indexOf(47, start);
        while (end > -1) {
            urlParams.add(this.destination.substring(start, end));
            start = end + 1;
            end = this.destination.indexOf(47, start);
        }
        if (urlParams.size() == 0) {
            String exceptionBuffer = "Malformed destinationURL - Must be of the format 'db://<data-source>[/<table>[/<repositoryName>]]'.  Was passed " + configuration.getString("[@destinationURL]");
            throw new ConfigurationException(exceptionBuffer);
        }
        if (urlParams.size() >= 1) {
            this.datasourceName = (String)urlParams.get(0);
        }
        if (urlParams.size() >= 2) {
            this.tableName = (String)urlParams.get(1);
        }
        if (urlParams.size() >= 3) {
            this.repositoryName = "";
            for (int i = 2; i < urlParams.size(); ++i) {
                if (i >= 3) {
                    this.repositoryName = this.repositoryName + '/';
                }
                this.repositoryName = this.repositoryName + (String)urlParams.get(i);
            }
        }
        LOGGER.debug("Parsed URL: table = '{}', repositoryName = '{}'", (Object)this.tableName, (Object)this.repositoryName);
        this.inMemorySizeLimit = configuration.getInt("inMemorySizeLimit", 409600000);
        this.filestore = configuration.getString("filestore", null);
        this.sqlFileName = configuration.getString("sqlFile");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void init() throws Exception {
        LOGGER.debug("{}.initialize()", (Object)((Object)((Object)this)).getClass().getName());
        try {
            if (this.filestore != null) {
                DefaultConfigurationBuilder streamConfiguration = new DefaultConfigurationBuilder();
                streamConfiguration.addProperty("[@destinationURL]", (Object)this.filestore);
                this.sr = new FilePersistentStreamRepository();
                this.sr.setFileSystem(this.fileSystem);
                this.sr.configure((HierarchicalConfiguration)streamConfiguration);
                this.sr.init();
                LOGGER.debug("Got filestore for JdbcMailRepository: {}", (Object)this.filestore);
            }
            LOGGER.debug("{} created according to {}", (Object)((Object)((Object)this)).getClass().getName(), (Object)this.destination);
        }
        catch (Exception e) {
            LOGGER.error("Failed to retrieve Store component", (Throwable)e);
            throw new ConfigurationException("Failed to retrieve Store component", (Throwable)e);
        }
        this.theJDBCUtil = new JDBCUtil();
        Connection conn = this.datasource.getConnection();
        PreparedStatement createStatement = null;
        try {
            InputStream sqlFile;
            try {
                sqlFile = this.fileSystem.getResource(this.sqlFileName);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw e;
            }
            LOGGER.debug("Reading SQL resources from file: {}, section {}.", (Object)this.sqlFileName, (Object)((Object)((Object)this)).getClass().getName());
            HashMap<String, String> sqlParameters = new HashMap<String, String>();
            if (this.tableName != null) {
                sqlParameters.put("table", this.tableName);
            }
            if (this.repositoryName != null) {
                sqlParameters.put("repository", this.repositoryName);
            }
            this.sqlQueries = new SqlResources();
            this.sqlQueries.init(sqlFile, ((Object)((Object)this)).getClass().getName(), conn, sqlParameters);
            DatabaseMetaData dbMetaData = conn.getMetaData();
            if (!this.theJDBCUtil.tableExists(dbMetaData, this.tableName)) {
                createStatement = conn.prepareStatement(this.sqlQueries.getSqlString("createTable", true));
                createStatement.execute();
                LOGGER.info("JdbcMailRepository: Created table '{}'.", (Object)this.tableName);
            }
            this.checkJdbcAttributesSupport(dbMetaData);
        }
        finally {
            this.theJDBCUtil.closeJDBCStatement(createStatement);
            this.theJDBCUtil.closeJDBCConnection(conn);
        }
    }

    protected void checkJdbcAttributesSupport(DatabaseMetaData dbMetaData) throws SQLException {
        String retrieveMessageAttrSql;
        String attributesColumnName = "message_attributes";
        boolean hasUpdateMessageAttributesSQL = false;
        boolean hasRetrieveMessageAttributesSQL = false;
        boolean hasMessageAttributesColumn = this.theJDBCUtil.columnExists(dbMetaData, this.tableName, attributesColumnName);
        StringBuilder logBuffer = new StringBuilder(64).append("JdbcMailRepository '").append(this.repositoryName).append(", table '").append(this.tableName).append("': ");
        String updateMessageAttrSql = this.sqlQueries.getSqlString("updateMessageAttributesSQL", false);
        if (updateMessageAttrSql != null) {
            hasUpdateMessageAttributesSQL = true;
        }
        if ((retrieveMessageAttrSql = this.sqlQueries.getSqlString("retrieveMessageAttributesSQL", false)) != null) {
            hasRetrieveMessageAttributesSQL = true;
        }
        if (hasUpdateMessageAttributesSQL && !hasRetrieveMessageAttributesSQL) {
            logBuffer.append("JDBC Mail Attributes support was activated for update but not for retrieval(found 'updateMessageAttributesSQL' but not 'retrieveMessageAttributesSQL'in table '").append(this.tableName).append("').");
            String logBufferAsString = logBuffer.toString();
            LOGGER.error(logBufferAsString);
            throw new SQLException(logBufferAsString);
        }
        if (!hasUpdateMessageAttributesSQL && hasRetrieveMessageAttributesSQL) {
            logBuffer.append("JDBC Mail Attributes support was activated for retrieval but not for update(found 'retrieveMessageAttributesSQL' but not 'updateMessageAttributesSQL'in table '").append(this.tableName).append("'.");
            String logBufferAsString = logBuffer.toString();
            LOGGER.error(logBufferAsString);
            throw new SQLException(logBufferAsString);
        }
        if (!hasMessageAttributesColumn && (hasUpdateMessageAttributesSQL || hasRetrieveMessageAttributesSQL)) {
            logBuffer.append("JDBC Mail Attributes support was activated but column '").append(attributesColumnName).append("' is missing in table '").append(this.tableName).append("'.");
            String logBufferAsString = logBuffer.toString();
            LOGGER.error(logBufferAsString);
            throw new SQLException(logBufferAsString);
        }
        if (hasUpdateMessageAttributesSQL && hasRetrieveMessageAttributesSQL) {
            this.jdbcMailAttributesReady = true;
            logBuffer.append("JDBC Mail Attributes support ready.");
            LOGGER.info("{}", (Object)logBuffer);
        } else {
            this.jdbcMailAttributesReady = false;
            logBuffer.append("JDBC Mail Attributes support not activated. Missing both 'updateMessageAttributesSQL' and 'retrieveMessageAttributesSQL' statements for table '").append(this.tableName).append("' in sqlResources.xml. ").append("Will not persist in the repository '").append(this.repositoryName).append("'.");
            LOGGER.warn("{}", (Object)logBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void internalStore(Mail mc) throws IOException, MessagingException {
        Connection conn = null;
        try {
            boolean saveBody;
            conn = this.datasource.getConnection();
            MimeMessage messageBody = mc.getMessage();
            if (messageBody instanceof MimeMessageCopyOnWriteProxy) {
                MimeMessageCopyOnWriteProxy messageCow = (MimeMessageCopyOnWriteProxy)messageBody;
                messageBody = messageCow.getWrappedMessage();
            }
            if (messageBody instanceof MimeMessageWrapper) {
                MimeMessageWrapper message = (MimeMessageWrapper)messageBody;
                saveBody = message.isModified();
                if (saveBody) {
                    message.loadMessage();
                }
            } else {
                saveBody = true;
            }
            MessageInputStream is = new MessageInputStream(mc, (StreamRepository)this.sr, this.inMemorySizeLimit, true);
            conn.setAutoCommit(false);
            PreparedStatement checkMessageExists = null;
            ResultSet rsExists = null;
            boolean exists = false;
            try {
                checkMessageExists = conn.prepareStatement(this.sqlQueries.getSqlString("checkMessageExistsSQL", true));
                checkMessageExists.setString(1, mc.getName());
                checkMessageExists.setString(2, this.repositoryName);
                rsExists = checkMessageExists.executeQuery();
                exists = rsExists.next() && rsExists.getInt(1) > 0;
            }
            catch (Throwable throwable) {
                this.theJDBCUtil.closeJDBCResultSet(rsExists);
                this.theJDBCUtil.closeJDBCStatement((Statement)checkMessageExists);
                throw throwable;
            }
            this.theJDBCUtil.closeJDBCResultSet(rsExists);
            this.theJDBCUtil.closeJDBCStatement((Statement)checkMessageExists);
            if (exists) {
                PreparedStatement updateMessage = null;
                try {
                    updateMessage = conn.prepareStatement(this.sqlQueries.getSqlString("updateMessageSQL", true));
                    updateMessage.setString(1, mc.getState());
                    updateMessage.setString(2, mc.getErrorMessage());
                    if (mc.getSender() == null) {
                        updateMessage.setNull(3, 12);
                    } else {
                        updateMessage.setString(3, mc.getSender().toString());
                    }
                    StringBuilder recipients = new StringBuilder();
                    Iterator i = mc.getRecipients().iterator();
                    while (i.hasNext()) {
                        recipients.append(((MailAddress)i.next()).toString());
                        if (!i.hasNext()) continue;
                        recipients.append("\r\n");
                    }
                    updateMessage.setString(4, recipients.toString());
                    updateMessage.setString(5, mc.getRemoteHost());
                    updateMessage.setString(6, mc.getRemoteAddr());
                    updateMessage.setTimestamp(7, new Timestamp(mc.getLastUpdated().getTime()));
                    updateMessage.setString(8, mc.getName());
                    updateMessage.setString(9, this.repositoryName);
                    updateMessage.execute();
                }
                finally {
                    PreparedStatement localUpdateMessage = updateMessage;
                    updateMessage = null;
                    this.theJDBCUtil.closeJDBCStatement((Statement)localUpdateMessage);
                }
                if (this.jdbcMailAttributesReady && mc.hasAttributes()) {
                    String updateMessageAttrSql = this.sqlQueries.getSqlString("updateMessageAttributesSQL", false);
                    PreparedStatement updateMessageAttr = null;
                    try {
                        updateMessageAttr = conn.prepareStatement(updateMessageAttrSql);
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        ObjectOutputStream oos = new ObjectOutputStream(baos);
                        try {
                            if (mc instanceof MailImpl) {
                                oos.writeObject(((MailImpl)mc).getAttributesRaw());
                            } else {
                                HashMap<String, Serializable> temp = new HashMap<String, Serializable>();
                                Iterator i = mc.getAttributeNames();
                                while (i.hasNext()) {
                                    String hashKey = (String)i.next();
                                    temp.put(hashKey, mc.getAttribute(hashKey));
                                }
                                oos.writeObject(temp);
                            }
                            oos.flush();
                            ByteArrayInputStream attrInputStream = new ByteArrayInputStream(baos.toByteArray());
                            updateMessageAttr.setBinaryStream(1, (InputStream)attrInputStream, baos.size());
                        }
                        finally {
                            try {
                                if (oos != null) {
                                    oos.close();
                                }
                            }
                            catch (IOException ioe) {
                                LOGGER.debug("JDBCMailRepository: Unexpected exception while closing output stream.", (Throwable)ioe);
                            }
                        }
                        updateMessageAttr.setString(2, mc.getName());
                        updateMessageAttr.setString(3, this.repositoryName);
                        updateMessageAttr.execute();
                    }
                    catch (SQLException sqle) {
                        LOGGER.info("JDBCMailRepository: Trying to update mail attributes failed.", (Throwable)sqle);
                    }
                    finally {
                        this.theJDBCUtil.closeJDBCStatement((Statement)updateMessageAttr);
                    }
                }
                if (saveBody) {
                    PreparedStatement updateMessageBody = conn.prepareStatement(this.sqlQueries.getSqlString("updateMessageBodySQL", true));
                    try {
                        updateMessageBody.setBinaryStream(1, (InputStream)is, (int)is.getSize());
                        updateMessageBody.setString(2, mc.getName());
                        updateMessageBody.setString(3, this.repositoryName);
                        updateMessageBody.execute();
                    }
                    finally {
                        this.theJDBCUtil.closeJDBCStatement((Statement)updateMessageBody);
                    }
                }
            } else {
                PreparedStatement insertMessage = null;
                try {
                    String insertMessageSQL = this.sqlQueries.getSqlString("insertMessageSQL", true);
                    insertMessage = conn.prepareStatement(insertMessageSQL);
                    int numberOfParameters = insertMessage.getParameterMetaData().getParameterCount();
                    insertMessage.setString(1, mc.getName());
                    insertMessage.setString(2, this.repositoryName);
                    insertMessage.setString(3, mc.getState());
                    insertMessage.setString(4, mc.getErrorMessage());
                    if (mc.getSender() == null) {
                        insertMessage.setNull(5, 12);
                    } else {
                        insertMessage.setString(5, mc.getSender().toString());
                    }
                    StringBuilder recipients = new StringBuilder();
                    Iterator i = mc.getRecipients().iterator();
                    while (i.hasNext()) {
                        recipients.append(((MailAddress)i.next()).toString());
                        if (!i.hasNext()) continue;
                        recipients.append("\r\n");
                    }
                    insertMessage.setString(6, recipients.toString());
                    insertMessage.setString(7, mc.getRemoteHost());
                    insertMessage.setString(8, mc.getRemoteAddr());
                    insertMessage.setTimestamp(9, new Timestamp(mc.getLastUpdated().getTime()));
                    insertMessage.setBinaryStream(10, (InputStream)is, (int)is.getSize());
                    if (numberOfParameters > 10) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        ObjectOutputStream oos = new ObjectOutputStream(baos);
                        try {
                            if (mc instanceof MailImpl) {
                                oos.writeObject(((MailImpl)mc).getAttributesRaw());
                            } else {
                                HashMap<String, Serializable> temp = new HashMap<String, Serializable>();
                                Iterator i2 = mc.getAttributeNames();
                                while (i2.hasNext()) {
                                    String hashKey = (String)i2.next();
                                    temp.put(hashKey, mc.getAttribute(hashKey));
                                }
                                oos.writeObject(temp);
                            }
                            oos.flush();
                            ByteArrayInputStream attrInputStream = new ByteArrayInputStream(baos.toByteArray());
                            insertMessage.setBinaryStream(11, (InputStream)attrInputStream, baos.size());
                        }
                        finally {
                            try {
                                if (oos != null) {
                                    oos.close();
                                }
                            }
                            catch (IOException ioe) {
                                LOGGER.debug("JDBCMailRepository: Unexpected exception while closing output stream.", (Throwable)ioe);
                            }
                        }
                    }
                    insertMessage.execute();
                }
                catch (Throwable throwable) {
                    this.theJDBCUtil.closeJDBCStatement(insertMessage);
                    throw throwable;
                }
                this.theJDBCUtil.closeJDBCStatement((Statement)insertMessage);
            }
            conn.commit();
            conn.setAutoCommit(true);
            return;
        }
        catch (SQLException e) {
            LOGGER.debug("Failed to store internal mail", (Throwable)e);
            throw new IOException(e.getMessage());
        }
        finally {
            this.theJDBCUtil.closeJDBCConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Mail retrieve(MailKey key) throws MessagingException {
        MailImpl mailImpl;
        ResultSet rsMessage;
        PreparedStatement retrieveMessage;
        Connection conn;
        block20: {
            conn = null;
            retrieveMessage = null;
            rsMessage = null;
            conn = this.datasource.getConnection();
            retrieveMessage = conn.prepareStatement(this.sqlQueries.getSqlString("retrieveMessageSQL", true));
            retrieveMessage.setString(1, key.asString());
            retrieveMessage.setString(2, this.repositoryName);
            rsMessage = retrieveMessage.executeQuery();
            if (rsMessage.next()) break block20;
            LOGGER.debug("Did not find a record {} in {}", (Object)key, (Object)this.repositoryName);
            Mail mail = null;
            this.theJDBCUtil.closeJDBCResultSet(rsMessage);
            this.theJDBCUtil.closeJDBCStatement((Statement)retrieveMessage);
            this.theJDBCUtil.closeJDBCConnection(conn);
            return mail;
        }
        try {
            PreparedStatement retrieveMessageAttr = null;
            HashMap attributes = null;
            if (this.jdbcMailAttributesReady) {
                ResultSet rsMessageAttr;
                block21: {
                    String retrieveMessageAttrSql = this.sqlQueries.getSqlString("retrieveMessageAttributesSQL", false);
                    rsMessageAttr = null;
                    try {
                        retrieveMessageAttr = conn.prepareStatement(retrieveMessageAttrSql);
                        retrieveMessageAttr.setString(1, key.asString());
                        retrieveMessageAttr.setString(2, this.repositoryName);
                        rsMessageAttr = retrieveMessageAttr.executeQuery();
                        if (rsMessageAttr.next()) {
                            try {
                                byte[] serializedAttr;
                                String getAttributesOption = this.sqlQueries.getDbOption("getAttributes");
                                if (getAttributesOption != null && (getAttributesOption.equalsIgnoreCase("useBlob") || getAttributesOption.equalsIgnoreCase("useBinaryStream"))) {
                                    Blob b = rsMessageAttr.getBlob(1);
                                    serializedAttr = b.getBytes(1L, (int)b.length());
                                } else {
                                    serializedAttr = rsMessageAttr.getBytes(1);
                                }
                                if (serializedAttr != null) {
                                    ByteArrayInputStream bais = new ByteArrayInputStream(serializedAttr);
                                    ObjectInputStream ois = new ObjectInputStream(bais);
                                    attributes = (HashMap)ois.readObject();
                                    ois.close();
                                }
                                break block21;
                            }
                            catch (IOException ioe) {
                                LOGGER.debug("Exception reading attributes {} in {}", new Object[]{key, this.repositoryName, ioe});
                            }
                            break block21;
                        }
                        LOGGER.debug("Did not find a record (attributes) {} in {}", (Object)key, (Object)this.repositoryName);
                    }
                    catch (SQLException sqle) {
                        try {
                            LOGGER.error("Error retrieving message{}{}{}{}", new Object[]{sqle.getMessage(), sqle.getErrorCode(), sqle.getSQLState(), String.valueOf(sqle.getNextException())});
                        }
                        catch (Throwable throwable) {
                            this.theJDBCUtil.closeJDBCResultSet(rsMessageAttr);
                            this.theJDBCUtil.closeJDBCStatement((Statement)retrieveMessageAttr);
                            throw throwable;
                        }
                        this.theJDBCUtil.closeJDBCResultSet(rsMessageAttr);
                        this.theJDBCUtil.closeJDBCStatement((Statement)retrieveMessageAttr);
                    }
                }
                this.theJDBCUtil.closeJDBCResultSet(rsMessageAttr);
                this.theJDBCUtil.closeJDBCStatement((Statement)retrieveMessageAttr);
            }
            MailImpl mc = new MailImpl();
            mc.setAttributesRaw(attributes);
            mc.setName(key.asString());
            mc.setState(rsMessage.getString(1));
            mc.setErrorMessage(rsMessage.getString(2));
            String sender = rsMessage.getString(3);
            if (sender == null) {
                mc.setSender(null);
            } else {
                mc.setSender(new MailAddress(sender));
            }
            StringTokenizer st = new StringTokenizer(rsMessage.getString(4), "\r\n", false);
            HashSet<MailAddress> recipients = new HashSet<MailAddress>();
            while (st.hasMoreTokens()) {
                recipients.add(new MailAddress(st.nextToken()));
            }
            mc.setRecipients(recipients);
            mc.setRemoteHost(rsMessage.getString(5));
            mc.setRemoteAddr(rsMessage.getString(6));
            mc.setLastUpdated((Date)rsMessage.getTimestamp(7));
            MimeMessageJDBCSource source = new MimeMessageJDBCSource(this, key.asString(), (StreamRepository)this.sr);
            MimeMessageCopyOnWriteProxy message = new MimeMessageCopyOnWriteProxy((MimeMessageSource)source);
            mc.setMessage((MimeMessage)message);
            mailImpl = mc;
        }
        catch (SQLException sqle) {
            try {
                LOGGER.error("Error retrieving message{}{}{}{}", new Object[]{sqle.getMessage(), sqle.getErrorCode(), sqle.getSQLState(), String.valueOf(sqle.getNextException())});
                LOGGER.debug("Failed to retrieve mail", (Throwable)sqle);
                throw new MessagingException("Exception while retrieving mail: " + sqle.getMessage(), (Exception)sqle);
                catch (Exception me) {
                    throw new MessagingException("Exception while retrieving mail: " + me.getMessage(), me);
                }
            }
            catch (Throwable throwable) {
                this.theJDBCUtil.closeJDBCResultSet(rsMessage);
                this.theJDBCUtil.closeJDBCStatement(retrieveMessage);
                this.theJDBCUtil.closeJDBCConnection(conn);
                throw throwable;
            }
        }
        this.theJDBCUtil.closeJDBCResultSet(rsMessage);
        this.theJDBCUtil.closeJDBCStatement((Statement)retrieveMessage);
        this.theJDBCUtil.closeJDBCConnection(conn);
        return mailImpl;
    }

    protected void internalRemove(MailKey key) throws MessagingException {
        Connection conn = null;
        PreparedStatement removeMessage = null;
        try {
            conn = this.datasource.getConnection();
            removeMessage = conn.prepareStatement(this.sqlQueries.getSqlString("removeMessageSQL", true));
            removeMessage.setString(1, key.asString());
            removeMessage.setString(2, this.repositoryName);
            removeMessage.execute();
            if (this.sr != null) {
                this.sr.remove(key.asString());
            }
        }
        catch (Exception me) {
            try {
                throw new MessagingException("Exception while removing mail: " + me.getMessage(), me);
            }
            catch (Throwable throwable) {
                this.theJDBCUtil.closeJDBCStatement(removeMessage);
                this.theJDBCUtil.closeJDBCConnection(conn);
                throw throwable;
            }
        }
        this.theJDBCUtil.closeJDBCStatement((Statement)removeMessage);
        this.theJDBCUtil.closeJDBCConnection(conn);
    }

    public Iterator<MailKey> list() throws MessagingException {
        Iterator<MailKey> iterator;
        Connection conn = null;
        PreparedStatement listMessages = null;
        ResultSet rsListMessages = null;
        try {
            conn = this.datasource.getConnection();
            listMessages = conn.prepareStatement(this.sqlQueries.getSqlString("listMessagesSQL", true));
            listMessages.setString(1, this.repositoryName);
            rsListMessages = listMessages.executeQuery();
            ArrayList<String> messageList = new ArrayList<String>();
            while (rsListMessages.next() && !Thread.currentThread().isInterrupted()) {
                messageList.add(rsListMessages.getString(1));
            }
            iterator = messageList.stream().map(MailKey::new).iterator();
        }
        catch (Exception me) {
            try {
                throw new MessagingException("Exception while listing mail: " + me.getMessage(), me);
            }
            catch (Throwable throwable) {
                this.theJDBCUtil.closeJDBCResultSet(rsListMessages);
                this.theJDBCUtil.closeJDBCStatement(listMessages);
                this.theJDBCUtil.closeJDBCConnection(conn);
                throw throwable;
            }
        }
        this.theJDBCUtil.closeJDBCResultSet(rsListMessages);
        this.theJDBCUtil.closeJDBCStatement((Statement)listMessages);
        this.theJDBCUtil.closeJDBCConnection(conn);
        return iterator;
    }

    protected Connection getConnection() throws SQLException {
        return this.datasource.getConnection();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JDBCMailRepository)) {
            return false;
        }
        JDBCMailRepository repository = (JDBCMailRepository)((Object)obj);
        return (repository.tableName.equals(this.tableName) || repository.tableName != null && repository.tableName.equals(this.tableName)) && (repository.repositoryName.equals(this.repositoryName) || repository.repositoryName != null && repository.repositoryName.equals(this.repositoryName));
    }

    public int hashCode() {
        int result = 17;
        if (this.tableName != null) {
            result = 37 * this.tableName.hashCode();
        }
        if (this.repositoryName != null) {
            result = 37 * this.repositoryName.hashCode();
        }
        return result;
    }
}

