/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.jdbc;

import java.sql.SQLException;
import java.util.Date;
import javax.sql.DataSource;
import org.apache.commons.configuration.DefaultConfigurationBuilder;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.derby.jdbc.EmbeddedDriver;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.filesystem.api.mock.MockFileSystem;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.mailrepository.MailRepositoryContract;
import org.apache.james.mailrepository.api.MailRepository;
import org.apache.james.mailrepository.jdbc.JDBCMailRepository;
import org.apache.mailet.Mail;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractDateAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class JDBCMailRepositoryTest
implements MailRepositoryContract {
    private JDBCMailRepository mailRepository;

    @BeforeEach
    void init() throws Exception {
        MockFileSystem fs = new MockFileSystem();
        BasicDataSource datasource = this.getDataSource();
        this.mailRepository = new JDBCMailRepository();
        DefaultConfigurationBuilder defaultConfiguration = new DefaultConfigurationBuilder();
        defaultConfiguration.addProperty("[@destinationURL]", (Object)"db://maildb/mr/testrepo");
        defaultConfiguration.addProperty("sqlFile", (Object)"file://conf/sqlResources.xml");
        defaultConfiguration.addProperty("[@type]", (Object)"MAIL");
        this.mailRepository.setFileSystem((FileSystem)fs);
        this.mailRepository.setDatasource((DataSource)datasource);
        this.mailRepository.configure((HierarchicalConfiguration)defaultConfiguration);
        this.mailRepository.init();
    }

    @AfterEach
    void tearDown() throws SQLException {
        this.mailRepository.getConnection().prepareStatement("DELETE from " + this.mailRepository.tableName).execute();
        LifecycleUtil.dispose((Object)this.mailRepository);
    }

    public MailRepository retrieveRepository() {
        return this.mailRepository;
    }

    private BasicDataSource getDataSource() {
        BasicDataSource ds = new BasicDataSource();
        ds.setDriverClassName(EmbeddedDriver.class.getName());
        ds.setUrl("jdbc:derby:target/testdb;create=true");
        ds.setUsername("james");
        ds.setPassword("james");
        return ds;
    }

    @Test
    @Disabled(value="JAMES-2304 JDBC doesn't update the message Content")
    public void storingMessageWithSameKeyTwiceShouldUpdateMessageContent() {
    }

    public void checkMailEquality(Mail actual, Mail expected) {
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> {
            AbstractObjectAssert cfr_ignored_0 = (AbstractObjectAssert)Assertions.assertThat((Object)actual.getMessage().getContent()).isEqualTo(expected.getMessage().getContent());
        }, () -> Assertions.assertThat((long)actual.getMessageSize()).isEqualTo(expected.getMessageSize()), () -> {
            AbstractCharSequenceAssert cfr_ignored_0 = (AbstractCharSequenceAssert)Assertions.assertThat((String)actual.getName()).isEqualTo((Object)expected.getName());
        }, () -> {
            AbstractCharSequenceAssert cfr_ignored_0 = (AbstractCharSequenceAssert)Assertions.assertThat((String)actual.getState()).isEqualTo((Object)expected.getState());
        }, () -> {
            AbstractObjectAssert cfr_ignored_0 = (AbstractObjectAssert)Assertions.assertThat((Object)actual.getAttribute("testAttribute")).isEqualTo((Object)expected.getAttribute("testAttribute"));
        }, () -> {
            AbstractCharSequenceAssert cfr_ignored_0 = (AbstractCharSequenceAssert)Assertions.assertThat((String)actual.getErrorMessage()).isEqualTo((Object)expected.getErrorMessage());
        }, () -> {
            AbstractCharSequenceAssert cfr_ignored_0 = (AbstractCharSequenceAssert)Assertions.assertThat((String)actual.getRemoteHost()).isEqualTo((Object)expected.getRemoteHost());
        }, () -> {
            AbstractCharSequenceAssert cfr_ignored_0 = (AbstractCharSequenceAssert)Assertions.assertThat((String)actual.getRemoteAddr()).isEqualTo((Object)expected.getRemoteAddr());
        }, () -> {
            AbstractDateAssert cfr_ignored_0 = (AbstractDateAssert)Assertions.assertThat((Date)actual.getLastUpdated()).isEqualTo((Object)expected.getLastUpdated());
        }});
    }
}

