/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.jdbc;

import javax.sql.DataSource;
import org.apache.commons.configuration.DefaultConfigurationBuilder;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.derby.jdbc.EmbeddedDriver;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.filesystem.api.mock.MockFileSystem;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.jdbc.JDBCRecipientRewriteTable;
import org.apache.james.rrt.lib.AbstractRecipientRewriteTable;
import org.apache.james.rrt.lib.AbstractRecipientRewriteTableTest;
import org.slf4j.LoggerFactory;

public class JDBCRecipientRewriteTableTest
extends AbstractRecipientRewriteTableTest {
    protected AbstractRecipientRewriteTable getRecipientRewriteTable() throws Exception {
        JDBCRecipientRewriteTable virtualUserTable = new JDBCRecipientRewriteTable();
        virtualUserTable.setLog(LoggerFactory.getLogger((String)"MockLog"));
        virtualUserTable.setDataSource((DataSource)this.getDataSource());
        virtualUserTable.setFileSystem((FileSystem)new MockFileSystem());
        DefaultConfigurationBuilder defaultConfiguration = new DefaultConfigurationBuilder();
        defaultConfiguration.addProperty("[@destinationURL]", (Object)"db://maildb/RecipientRewriteTable");
        defaultConfiguration.addProperty("sqlFile", (Object)"file://conf/sqlResources.xml");
        virtualUserTable.configure((HierarchicalConfiguration)defaultConfiguration);
        virtualUserTable.init();
        return virtualUserTable;
    }

    private BasicDataSource getDataSource() {
        BasicDataSource ds = new BasicDataSource();
        ds.setDriverClassName(EmbeddedDriver.class.getName());
        ds.setUrl("jdbc:derby:target/testdb;create=true");
        ds.setUsername("james");
        ds.setPassword("james");
        return ds;
    }

    protected boolean addMapping(String user, String domain, String mapping, int type) throws RecipientRewriteTableException {
        block6: {
            try {
                if (type == 1) {
                    this.virtualUserTable.addErrorMapping(user, domain, mapping);
                    break block6;
                }
                if (type == 0) {
                    this.virtualUserTable.addRegexMapping(user, domain, mapping);
                    break block6;
                }
                if (type == 2) {
                    this.virtualUserTable.addAddressMapping(user, domain, mapping);
                    break block6;
                }
                if (type == 3) {
                    this.virtualUserTable.addAliasDomainMapping(domain, mapping);
                    break block6;
                }
                return false;
            }
            catch (RecipientRewriteTableException ex) {
                return false;
            }
        }
        return true;
    }

    protected boolean removeMapping(String user, String domain, String mapping, int type) throws RecipientRewriteTableException {
        block6: {
            try {
                if (type == 1) {
                    this.virtualUserTable.removeErrorMapping(user, domain, mapping);
                    break block6;
                }
                if (type == 0) {
                    this.virtualUserTable.removeRegexMapping(user, domain, mapping);
                    break block6;
                }
                if (type == 2) {
                    this.virtualUserTable.removeAddressMapping(user, domain, mapping);
                    break block6;
                }
                if (type == 3) {
                    this.virtualUserTable.removeAliasDomainMapping(domain, mapping);
                    break block6;
                }
                return false;
            }
            catch (RecipientRewriteTableException ex) {
                return false;
            }
        }
        return true;
    }
}

