/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.jdbc;

import javax.sql.DataSource;
import org.apache.commons.configuration.DefaultConfigurationBuilder;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.derby.jdbc.EmbeddedDriver;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.filesystem.api.mock.MockFileSystem;
import org.apache.james.mailrepository.AbstractMailRepositoryTest;
import org.apache.james.mailrepository.api.MailRepository;
import org.apache.james.mailrepository.jdbc.JDBCMailRepository;
import org.slf4j.LoggerFactory;

public class JDBCMailRepositoryTest
extends AbstractMailRepositoryTest {
    protected MailRepository getMailRepository() throws Exception {
        MockFileSystem fs = new MockFileSystem();
        BasicDataSource datasource = this.getDataSource();
        JDBCMailRepository mr = new JDBCMailRepository();
        DefaultConfigurationBuilder defaultConfiguration = new DefaultConfigurationBuilder();
        defaultConfiguration.addProperty("[@destinationURL]", (Object)"db://maildb/mr/testrepo");
        defaultConfiguration.addProperty("sqlFile", (Object)"file://conf/sqlResources.xml");
        defaultConfiguration.addProperty("[@type]", (Object)"MAIL");
        mr.setFileSystem((FileSystem)fs);
        mr.setDatasource((DataSource)datasource);
        mr.setLog(LoggerFactory.getLogger((String)"MockLog"));
        mr.configure((HierarchicalConfiguration)defaultConfiguration);
        mr.init();
        return mr;
    }

    protected String getType() {
        return "db";
    }

    private BasicDataSource getDataSource() {
        BasicDataSource ds = new BasicDataSource();
        ds.setDriverClassName(EmbeddedDriver.class.getName());
        ds.setUrl("jdbc:derby:target/testdb;create=true");
        ds.setUsername("james");
        ds.setPassword("james");
        return ds;
    }
}

