/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.hbase;

import com.google.common.base.Throwables;
import cucumber.api.java.After;
import cucumber.api.java.Before;
import java.io.IOException;
import org.apache.commons.configuration.DefaultConfigurationBuilder;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.hadoop.conf.Configuration;
import org.apache.james.domainlist.hbase.def.HDomainList;
import org.apache.james.mailbox.hbase.HBaseClusterSingleton;
import org.apache.james.rrt.hbase.HBaseRecipientRewriteTable;
import org.apache.james.rrt.hbase.def.HRecipientRewriteTable;
import org.apache.james.rrt.lib.AbstractRecipientRewriteTable;
import org.apache.james.rrt.lib.RewriteTablesStepdefs;
import org.apache.james.system.hbase.TablePool;
import org.apache.james.user.hbase.def.HUsersRepository;
import org.slf4j.LoggerFactory;

public class HBaseStepdefs {
    private static final HBaseClusterSingleton cluster = HBaseClusterSingleton.build();
    private RewriteTablesStepdefs mainStepdefs;

    public HBaseStepdefs(RewriteTablesStepdefs mainStepdefs) {
        try {
            this.mainStepdefs = mainStepdefs;
            TablePool.getInstance((Configuration)cluster.getConf());
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    @Before
    public void setup() throws Throwable {
        this.mainStepdefs.rewriteTable = this.getRecipientRewriteTable();
    }

    @After
    public void tearDown() {
        cluster.clearTable(new String(HDomainList.TABLE_NAME));
        cluster.clearTable(new String(HRecipientRewriteTable.TABLE_NAME));
        cluster.clearTable(new String(HUsersRepository.TABLE_NAME));
    }

    private AbstractRecipientRewriteTable getRecipientRewriteTable() throws Exception {
        HBaseRecipientRewriteTable rrt = new HBaseRecipientRewriteTable();
        rrt.setLog(LoggerFactory.getLogger((String)"MockLog"));
        rrt.configure((HierarchicalConfiguration)new DefaultConfigurationBuilder());
        return rrt;
    }
}

