/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.hbase;

import java.io.IOException;
import org.apache.commons.configuration.DefaultConfigurationBuilder;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.hadoop.conf.Configuration;
import org.apache.james.mailbox.hbase.HBaseClusterSingleton;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.hbase.HBaseRecipientRewriteTable;
import org.apache.james.rrt.lib.AbstractRecipientRewriteTable;
import org.apache.james.rrt.lib.AbstractRecipientRewriteTableTest;
import org.apache.james.system.hbase.TablePool;
import org.junit.Before;
import org.slf4j.LoggerFactory;

public class HBaseRecipientRewriteTableTest
extends AbstractRecipientRewriteTableTest {
    private static final HBaseClusterSingleton cluster = HBaseClusterSingleton.build();

    @Before
    public void setMeUp() throws IOException {
        TablePool.getInstance((Configuration)cluster.getConf());
    }

    protected AbstractRecipientRewriteTable getRecipientRewriteTable() throws Exception {
        HBaseRecipientRewriteTable rrt = new HBaseRecipientRewriteTable();
        rrt.setLog(LoggerFactory.getLogger((String)"MockLog"));
        rrt.configure((HierarchicalConfiguration)new DefaultConfigurationBuilder());
        return rrt;
    }

    protected boolean addMapping(String user, String domain, String mapping, int type) throws RecipientRewriteTableException {
        try {
            if (type == 1) {
                this.virtualUserTable.addErrorMapping(user, domain, mapping);
            } else if (type == 0) {
                this.virtualUserTable.addRegexMapping(user, domain, mapping);
            } else if (type == 2) {
                this.virtualUserTable.addAddressMapping(user, domain, mapping);
            } else if (type == 3) {
                this.virtualUserTable.addAliasDomainMapping(domain, mapping);
            } else {
                return false;
            }
            return true;
        }
        catch (RecipientRewriteTableException e) {
            return false;
        }
    }

    protected boolean removeMapping(String user, String domain, String mapping, int type) throws RecipientRewriteTableException {
        try {
            if (type == 1) {
                this.virtualUserTable.removeErrorMapping(user, domain, mapping);
            } else if (type == 0) {
                this.virtualUserTable.removeRegexMapping(user, domain, mapping);
            } else if (type == 2) {
                this.virtualUserTable.removeAddressMapping(user, domain, mapping);
            } else if (type == 3) {
                this.virtualUserTable.removeAliasDomainMapping(domain, mapping);
            } else {
                return false;
            }
            return true;
        }
        catch (RecipientRewriteTableException e) {
            return false;
        }
    }
}

