/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.hbase;

import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.configuration.DefaultConfigurationBuilder;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.hadoop.conf.Configuration;
import org.apache.james.mailbox.hbase.HBaseClusterSingleton;
import org.apache.james.system.hbase.TablePool;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.user.hbase.HBaseUsersRepository;
import org.apache.james.user.lib.AbstractUsersRepository;
import org.apache.james.user.lib.AbstractUsersRepositoryTest;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.LoggerFactory;

public class HBaseUsersRepositoryTest
extends AbstractUsersRepositoryTest {
    private static final HBaseClusterSingleton cluster = HBaseClusterSingleton.build();

    @BeforeClass
    public static void setMeUp() throws IOException {
        TablePool.getInstance((Configuration)cluster.getConf());
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.deleteAll();
    }

    private void deleteAll() throws Exception {
        Iterator it = this.getUsersRepository().list();
        while (it.hasNext()) {
            this.getUsersRepository().removeUser((String)it.next());
        }
    }

    protected AbstractUsersRepository getUsersRepository() throws Exception {
        HBaseUsersRepository userRepository = new HBaseUsersRepository();
        userRepository.setLog(LoggerFactory.getLogger((String)"MockLog"));
        userRepository.configure((HierarchicalConfiguration)new DefaultConfigurationBuilder());
        return userRepository;
    }

    @Ignore
    @Test(expected=UsersRepositoryException.class)
    public void removeUserShouldThrowWhenUserNotInRepository() throws UsersRepositoryException {
    }
}

