/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.file;

import java.util.ArrayList;
import java.util.Optional;
import org.apache.commons.configuration.DefaultConfigurationBuilder;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.file.XMLRecipientRewriteTable;
import org.apache.james.rrt.lib.AbstractRecipientRewriteTable;
import org.apache.james.rrt.lib.AbstractRecipientRewriteTableTest;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.MappingSource;
import org.apache.james.rrt.lib.Mappings;
import org.apache.james.rrt.lib.MappingsImpl;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class XMLRecipientRewriteTableTest
extends AbstractRecipientRewriteTableTest {
    private final DefaultConfigurationBuilder defaultConfiguration = new DefaultConfigurationBuilder();

    @Before
    public void setUp() throws Exception {
        this.defaultConfiguration.setDelimiterParsingDisabled(true);
        super.setUp();
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    protected AbstractRecipientRewriteTable getRecipientRewriteTable() {
        return new XMLRecipientRewriteTable(){

            public void addMapping(MappingSource source, Mapping mapping) throws RecipientRewriteTableException {
                XMLRecipientRewriteTableTest.this.addMappingToConfiguration(source, mapping.getType().withoutPrefix(mapping.asString()), mapping.getType());
            }

            public void removeMapping(MappingSource source, Mapping mapping) throws RecipientRewriteTableException {
                XMLRecipientRewriteTableTest.this.removeMappingFromConfiguration(source, mapping.getType().withoutPrefix(mapping.asString()), mapping.getType());
            }

            public void addAddressMapping(MappingSource source, String address) throws RecipientRewriteTableException {
                this.addMapping(source, Mapping.address((String)address));
            }
        };
    }

    @Test
    @Ignore(value="addMapping doesn't handle checking for duplicate in this test implementation")
    public void addMappingShouldThrowWhenMappingAlreadyExists() {
    }

    protected void addMappingToConfiguration(MappingSource source, String mapping, Mapping.Type type) throws RecipientRewriteTableException {
        Mappings mappings = Optional.ofNullable(this.virtualUserTable.getUserDomainMappings(source)).orElse((Mappings)MappingsImpl.empty());
        MappingsImpl updatedMappings = MappingsImpl.from((Mappings)mappings).add(Mapping.of((Mapping.Type)type, (String)mapping)).build();
        this.updateConfiguration(source, mappings, (Mappings)updatedMappings);
    }

    protected void removeMappingFromConfiguration(MappingSource source, String mapping, Mapping.Type type) throws RecipientRewriteTableException {
        Mappings oldMappings = Optional.ofNullable(this.virtualUserTable.getUserDomainMappings(source)).orElseThrow(() -> new RecipientRewriteTableException("Cannot remove from null mappings"));
        Mappings updatedMappings = oldMappings.remove(Mapping.of((Mapping.Type)type, (String)mapping));
        this.updateConfiguration(source, oldMappings, updatedMappings);
    }

    private void updateConfiguration(MappingSource source, Mappings oldMappings, Mappings updatedMappings) throws RecipientRewriteTableException {
        block4: {
            if (oldMappings != null) {
                this.removeMappingsFromConfig(source, oldMappings);
            }
            if (!updatedMappings.isEmpty()) {
                this.defaultConfiguration.addProperty("mapping", (Object)(source.getFixedUser() + "@" + source.getFixedDomain() + "=" + updatedMappings.serialize()));
            }
            try {
                this.virtualUserTable.configure((HierarchicalConfiguration)this.defaultConfiguration);
            }
            catch (Exception e) {
                if (updatedMappings.size() <= 0) break block4;
                throw new RecipientRewriteTableException("Error update mapping", (Throwable)e);
            }
        }
    }

    private void removeMappingsFromConfig(MappingSource source, Mappings mappings) {
        ArrayList<String> stored = new ArrayList<String>();
        for (String c : this.defaultConfiguration.getStringArray("mapping")) {
            String mapping = source.getFixedUser() + "@" + source.getFixedDomain() + "=" + mappings.serialize();
            if (c.equalsIgnoreCase(mapping)) continue;
            stored.add(c);
        }
        this.defaultConfiguration.clear();
        for (String aStored : stored) {
            this.defaultConfiguration.addProperty("mapping", (Object)aStored);
        }
    }
}

