/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository;

import org.apache.commons.configuration.DefaultConfigurationBuilder;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.filesystem.api.mock.MockFileSystem;
import org.apache.james.mailrepository.MailRepositoryContract;
import org.apache.james.mailrepository.api.MailRepository;
import org.apache.james.mailrepository.file.FileMailRepository;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;

public class FileMailRepositoryTest {

    @Nested
    @DisplayName(value="Fifo no cache configuration")
    public class FifoNoCacheFileMailRepositoryTest
    extends GenericFileMailRepositoryTest {
        @Override
        protected DefaultConfigurationBuilder withConfigurationOptions(DefaultConfigurationBuilder configuration) {
            configuration.addProperty("[@FIFO]", (Object)"true");
            configuration.addProperty("[@CACHEKEYS]", (Object)"false");
            return configuration;
        }
    }

    @Nested
    @DisplayName(value="Fifo configuration")
    public class FifoFileMailRepositoryTest
    extends GenericFileMailRepositoryTest {
        @Override
        protected DefaultConfigurationBuilder withConfigurationOptions(DefaultConfigurationBuilder configuration) {
            configuration.addProperty("[@FIFO]", (Object)"true");
            configuration.addProperty("[@CACHEKEYS]", (Object)"true");
            return configuration;
        }
    }

    @Nested
    @DisplayName(value="No cache configuration")
    public class NoCacheFileMailRepositoryTest
    extends GenericFileMailRepositoryTest {
        @Override
        protected DefaultConfigurationBuilder withConfigurationOptions(DefaultConfigurationBuilder configuration) {
            configuration.addProperty("[@FIFO]", (Object)"false");
            configuration.addProperty("[@CACHEKEYS]", (Object)"false");
            return configuration;
        }
    }

    @Nested
    @DisplayName(value="Default configuration")
    public class DefaultFileMailRepositoryTest
    extends GenericFileMailRepositoryTest {
        @Override
        protected DefaultConfigurationBuilder withConfigurationOptions(DefaultConfigurationBuilder configuration) {
            configuration.addProperty("[@FIFO]", (Object)"false");
            configuration.addProperty("[@CACHEKEYS]", (Object)"true");
            return configuration;
        }
    }

    public abstract class GenericFileMailRepositoryTest
    implements MailRepositoryContract {
        private FileMailRepository mailRepository;
        private MockFileSystem filesystem;

        @BeforeEach
        void init() throws Exception {
            this.filesystem = new MockFileSystem();
            this.mailRepository = new FileMailRepository();
            this.mailRepository.setFileSystem((FileSystem)this.filesystem);
            this.mailRepository.configure((HierarchicalConfiguration)this.getConfiguration());
            this.mailRepository.init();
        }

        protected DefaultConfigurationBuilder getConfiguration() {
            DefaultConfigurationBuilder configuration = new DefaultConfigurationBuilder();
            configuration.addProperty("[@destinationURL]", (Object)"file://target/var/mailRepository");
            return this.withConfigurationOptions(configuration);
        }

        protected abstract DefaultConfigurationBuilder withConfigurationOptions(DefaultConfigurationBuilder var1);

        @AfterEach
        void tearDown() {
            this.filesystem.clear();
        }

        public MailRepository retrieveRepository() {
            return this.mailRepository;
        }
    }
}

