/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.domainlist.xml;

import com.google.common.collect.ImmutableList;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.List;
import org.apache.james.core.Domain;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.dnsservice.api.mock.MockDNSService;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.domainlist.lib.DomainListConfiguration;
import org.apache.james.domainlist.xml.XMLDomainList;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class XMLDomainListTest {
    public static final Domain DEFAULT_DOMAIN = Domain.of((String)"default.domain");
    public static final Domain DOMAIN_1 = Domain.of((String)"domain1");
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    private DNSService setUpDNSServer(final String hostName) {
        return new MockDNSService(){

            public String getHostName(InetAddress inet) {
                return hostName;
            }

            public Collection<InetAddress> getAllByName(String name) throws UnknownHostException {
                return ImmutableList.of((Object)InetAddress.getByName("127.0.0.1"));
            }

            public InetAddress getLocalHost() throws UnknownHostException {
                return InetAddress.getLocalHost();
            }
        };
    }

    @Test
    public void testNoConfiguredDomains() throws Exception {
        XMLDomainList dom = new XMLDomainList(this.setUpDNSServer("localhost"));
        dom.configure(DomainListConfiguration.builder().autoDetect(false).autoDetectIp(false).defaultDomain(DEFAULT_DOMAIN));
        Assertions.assertThat((List)dom.getDomains()).containsOnly((Object[])new Domain[]{DEFAULT_DOMAIN});
    }

    @Test
    public void testGetDomains() throws Exception {
        XMLDomainList dom = new XMLDomainList(this.setUpDNSServer("localhost"));
        dom.configure(DomainListConfiguration.builder().autoDetect(false).autoDetectIp(false).addConfiguredDomains(new Domain[]{Domain.of((String)"domain1."), Domain.of((String)"domain2.")}).defaultDomain(DEFAULT_DOMAIN));
        Assertions.assertThat((List)dom.getDomains()).hasSize(3);
    }

    @Test
    public void testGetDomainsAutoDetectNotLocalHost() throws Exception {
        XMLDomainList dom = new XMLDomainList(this.setUpDNSServer("local"));
        dom.configure(DomainListConfiguration.builder().autoDetect(true).autoDetectIp(false).addConfiguredDomains(new Domain[]{Domain.of((String)"domain1.")}).defaultDomain(DEFAULT_DOMAIN));
        Assertions.assertThat((List)dom.getDomains()).hasSize(3);
    }

    @Test
    public void testGetDomainsAutoDetectLocalHost() throws Exception {
        XMLDomainList dom = new XMLDomainList(this.setUpDNSServer("localhost"));
        dom.configure(DomainListConfiguration.builder().autoDetect(false).autoDetectIp(false).addConfiguredDomains(new Domain[]{Domain.of((String)"domain1.")}).defaultDomain(DEFAULT_DOMAIN));
        Assertions.assertThat((List)dom.getDomains()).hasSize(2);
    }

    @Test
    public void addDomainShouldFailWhenAlreadyConfigured() throws Exception {
        this.expectedException.expect(DomainListException.class);
        XMLDomainList testee = new XMLDomainList(this.setUpDNSServer("hostname"));
        testee.configure(DomainListConfiguration.builder().autoDetect(true).autoDetectIp(false).addConfiguredDomain(DOMAIN_1).defaultDomain(DEFAULT_DOMAIN));
        testee.addDomain(Domain.of((String)"newDomain"));
    }

    @Test
    public void removeDomainShouldFailWhenAlreadyConfigured() throws Exception {
        this.expectedException.expect(DomainListException.class);
        XMLDomainList testee = new XMLDomainList(this.setUpDNSServer("localhost"));
        testee.configure(DomainListConfiguration.builder().autoDetect(true).autoDetectIp(false).addConfiguredDomain(DOMAIN_1));
        testee.removeDomain(Domain.of((String)"newDomain"));
    }

    @Test
    public void configureShouldNotFailWhenConfiguringDefaultDomain() throws Exception {
        XMLDomainList testee = new XMLDomainList(this.setUpDNSServer("localhost"));
        testee.configure(DomainListConfiguration.builder().autoDetect(false).autoDetectIp(false).defaultDomain(Domain.LOCALHOST).addConfiguredDomain(DOMAIN_1));
        Assertions.assertThat((List)testee.getDomainListInternal()).containsOnly((Object[])new Domain[]{DOMAIN_1, Domain.LOCALHOST});
    }
}

