/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.commons.configuration.DefaultConfigurationBuilder;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.user.file.UsersFileRepository;
import org.apache.james.user.lib.AbstractUsersRepository;
import org.apache.james.user.lib.AbstractUsersRepositoryTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.LoggerFactory;

public class UsersFileRepositoryTest
extends AbstractUsersRepositoryTest {
    private static final String TARGET_REPOSITORY_FOLDER = "target/var/users";
    private File targetRepositoryFolder;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.targetRepositoryFolder = new File(TARGET_REPOSITORY_FOLDER);
        this.usersRepository = this.getUsersRepository();
    }

    @After
    public void tearDown() throws IOException {
        FileUtils.forceDelete((File)this.targetRepositoryFolder);
    }

    protected AbstractUsersRepository getUsersRepository() throws Exception {
        FileSystem fs = new FileSystem(){

            public File getBasedir() throws FileNotFoundException {
                return new File(".");
            }

            public InputStream getResource(String url) throws IOException {
                return new FileInputStream(this.getFile(url));
            }

            public File getFile(String fileURL) throws FileNotFoundException {
                return new File(fileURL.substring("file://".length()));
            }
        };
        DefaultConfigurationBuilder configuration = new DefaultConfigurationBuilder("test");
        configuration.addProperty("destination.[@URL]", (Object)"file://target/var/users");
        configuration.addProperty("ignoreCase", (Object)"false");
        UsersFileRepository res = new UsersFileRepository();
        res.setFileSystem(fs);
        res.setLog(LoggerFactory.getLogger((String)"MockLog"));
        res.configure((HierarchicalConfiguration)configuration);
        res.init();
        return res;
    }

    @Ignore
    @Test
    public void addUserShouldThrowWhenSameUsernameWithDifferentCase() throws UsersRepositoryException {
    }

    protected void disposeUsersRepository() throws UsersRepositoryException {
        if (this.usersRepository != null) {
            Iterator i = this.usersRepository.list();
            while (i.hasNext()) {
                this.usersRepository.removeUser((String)i.next());
            }
            LifecycleUtil.dispose((Object)this.usersRepository);
        }
    }
}

