/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.sieverepository.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.sieverepository.api.SieveRepository;
import org.apache.james.sieverepository.file.SieveFileRepository;
import org.apache.james.sieverepository.lib.AbstractSieveRepositoryTest;

public class SieveFileRepositoryTest
extends AbstractSieveRepositoryTest {
    private static final String SIEVE_ROOT = "file://sieve";
    private final FileSystem fileSystem = new FileSystem(){

        public File getBasedir() throws FileNotFoundException {
            return new File(System.getProperty("java.io.tmpdir"));
        }

        public InputStream getResource(String url) throws IOException {
            return new FileInputStream(this.getFile(url));
        }

        public File getFile(String fileURL) throws FileNotFoundException {
            return new File(this.getBasedir(), fileURL.substring("file://".length()));
        }
    };

    protected SieveRepository createSieveRepository() throws Exception {
        return new SieveFileRepository(this.fileSystem);
    }

    protected void cleanUp() throws Exception {
        File root = this.fileSystem.getFile(SIEVE_ROOT);
        if (root.exists()) {
            FileUtils.forceDelete((File)root);
        }
    }
}

