/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.file;

import com.google.common.base.Optional;
import java.util.ArrayList;
import org.apache.commons.configuration.DefaultConfigurationBuilder;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.file.XMLRecipientRewriteTable;
import org.apache.james.rrt.lib.AbstractRecipientRewriteTable;
import org.apache.james.rrt.lib.AbstractRecipientRewriteTableTest;
import org.apache.james.rrt.lib.Mappings;
import org.apache.james.rrt.lib.MappingsImpl;
import org.junit.Before;
import org.slf4j.LoggerFactory;

public class XMLRecipientRewriteTableTest
extends AbstractRecipientRewriteTableTest {
    private final DefaultConfigurationBuilder defaultConfiguration = new DefaultConfigurationBuilder();

    @Before
    public void setUp() throws Exception {
        this.defaultConfiguration.setDelimiterParsingDisabled(true);
        super.setUp();
    }

    protected AbstractRecipientRewriteTable getRecipientRewriteTable() throws Exception {
        XMLRecipientRewriteTable localVirtualUserTable = new XMLRecipientRewriteTable();
        localVirtualUserTable.setLog(LoggerFactory.getLogger((String)"MockLog"));
        return localVirtualUserTable;
    }

    protected boolean addMapping(String user, String domain, String mapping, int type) throws RecipientRewriteTableException {
        Mappings mappings = this.virtualUserTable.getUserDomainMappings(user, domain);
        if (mappings != null) {
            this.removeMappingsFromConfig(user, domain, mappings);
        }
        MappingsImpl.Builder builder = MappingsImpl.from((Mappings)((Mappings)Optional.fromNullable((Object)mappings).or((Object)MappingsImpl.empty())));
        if (type == 1) {
            builder.add("error:" + mapping);
        } else if (type == 0) {
            builder.add("regex:" + mapping);
        } else if (type == 2) {
            builder.add(mapping);
        } else if (type == 3) {
            builder.add("domain:" + mapping);
        }
        MappingsImpl updatedMappings = builder.build();
        if (!updatedMappings.isEmpty()) {
            this.defaultConfiguration.addProperty("mapping", (Object)(user + "@" + domain + "=" + updatedMappings.serialize()));
        }
        try {
            this.virtualUserTable.configure((HierarchicalConfiguration)this.defaultConfiguration);
        }
        catch (Exception e) {
            return updatedMappings.size() <= 0;
        }
        return true;
    }

    protected boolean removeMapping(String user, String domain, String mapping, int type) throws RecipientRewriteTableException {
        Mappings mappings = this.virtualUserTable.getUserDomainMappings(user, domain);
        if (mappings == null) {
            return false;
        }
        this.removeMappingsFromConfig(user, domain, mappings);
        if (type == 1) {
            mappings = mappings.remove("error:" + mapping);
        } else if (type == 0) {
            mappings = mappings.remove("regex:" + mapping);
        } else if (type == 2) {
            mappings = mappings.remove(mapping);
        } else if (type == 3) {
            mappings = mappings.remove("domain:" + mapping);
        }
        if (mappings.size() > 0) {
            this.defaultConfiguration.addProperty("mapping", (Object)(user + "@" + domain + "=" + mappings.serialize()));
        }
        try {
            this.virtualUserTable.configure((HierarchicalConfiguration)this.defaultConfiguration);
        }
        catch (Exception e) {
            return mappings.size() <= 0;
        }
        return true;
    }

    private void removeMappingsFromConfig(String user, String domain, Mappings mappings) {
        ArrayList<String> stored = new ArrayList<String>();
        for (String c : this.defaultConfiguration.getStringArray("mapping")) {
            String mapping = user + "@" + domain + "=" + mappings.serialize();
            if (c.equalsIgnoreCase(mapping)) continue;
            stored.add(c);
        }
        this.defaultConfiguration.clear();
        for (String aStored : stored) {
            this.defaultConfiguration.addProperty("mapping", (Object)aStored);
        }
    }
}

