/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository;

import java.io.File;
import java.util.Iterator;
import org.apache.commons.configuration.DefaultConfigurationBuilder;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.filesystem.api.mock.MockFileSystem;
import org.apache.james.mailrepository.api.MailRepository;
import org.apache.james.mailrepository.file.MBoxMailRepository;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.LoggerFactory;

public class MBoxMailRepositoryTest {
    protected MailRepository getMailRepository() throws Exception {
        MBoxMailRepository mr = new MBoxMailRepository();
        DefaultConfigurationBuilder defaultConfiguration = new DefaultConfigurationBuilder();
        File fInbox = new MockFileSystem().getFile("file://conf/org/apache/james/mailrepository/testdata/Inbox");
        String mboxPath = "mbox://" + fInbox.toURI().toString().substring(new File("").toURI().toString().length());
        defaultConfiguration.addProperty("[@destinationURL]", (Object)mboxPath);
        defaultConfiguration.addProperty("[@type]", (Object)"MAIL");
        mr.setLog(LoggerFactory.getLogger((String)"MockLog"));
        mr.configure((HierarchicalConfiguration)defaultConfiguration);
        return mr;
    }

    @Test
    public void testReadMboxrdFile() throws Exception {
        MailRepository mr = this.getMailRepository();
        Iterator keys = mr.list();
        Assert.assertTrue((String)"Two messages in list", (boolean)keys.hasNext());
        keys.next();
        Assert.assertTrue((String)"One messages in list", (boolean)keys.hasNext());
        keys.next();
        Assert.assertFalse((String)"No messages", (boolean)keys.hasNext());
    }
}

