/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.domainlist.xml;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration.DefaultConfigurationBuilder;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.dnsservice.api.mock.MockDNSService;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.domainlist.xml.XMLDomainList;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.slf4j.LoggerFactory;

public class XMLDomainListTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    private HierarchicalConfiguration setUpConfiguration(boolean auto, boolean autoIP, List<String> names) {
        DefaultConfigurationBuilder configuration = new DefaultConfigurationBuilder();
        configuration.addProperty("autodetect", (Object)auto);
        configuration.addProperty("autodetectIP", (Object)autoIP);
        for (String name : names) {
            configuration.addProperty("domainnames.domainname", (Object)name);
        }
        configuration.addProperty("defaultDomain", (Object)"default.domain");
        return configuration;
    }

    private DNSService setUpDNSServer(final String hostName) {
        return new MockDNSService(){

            public String getHostName(InetAddress inet) {
                return hostName;
            }

            public InetAddress[] getAllByName(String name) throws UnknownHostException {
                return new InetAddress[]{InetAddress.getByName("127.0.0.1")};
            }

            public InetAddress getLocalHost() throws UnknownHostException {
                return InetAddress.getLocalHost();
            }
        };
    }

    @Test
    public void testNoConfiguredDomains() throws Exception {
        ArrayList<String> domains = new ArrayList<String>();
        XMLDomainList dom = new XMLDomainList();
        dom.setLog(LoggerFactory.getLogger((String)"MockLog"));
        dom.configure(this.setUpConfiguration(false, false, domains));
        dom.setDNSService(this.setUpDNSServer("localhost"));
        ((AbstractListAssert)Assertions.assertThat((List)dom.getDomains()).describedAs("No domain found", new Object[0])).isEmpty();
    }

    @Test
    public void testGetDomains() throws Exception {
        ArrayList<String> domains = new ArrayList<String>();
        domains.add("domain1.");
        domains.add("domain2.");
        XMLDomainList dom = new XMLDomainList();
        dom.setLog(LoggerFactory.getLogger((String)"MockLog"));
        dom.configure(this.setUpConfiguration(false, false, domains));
        dom.setDNSService(this.setUpDNSServer("localhost"));
        ((AbstractListAssert)Assertions.assertThat((List)dom.getDomains()).describedAs("Two domain found", new Object[0])).hasSize(2);
    }

    @Test
    public void testGetDomainsAutoDetectNotLocalHost() throws Exception {
        ArrayList<String> domains = new ArrayList<String>();
        domains.add("domain1.");
        XMLDomainList dom = new XMLDomainList();
        dom.setLog(LoggerFactory.getLogger((String)"MockLog"));
        dom.configure(this.setUpConfiguration(true, false, domains));
        dom.setDNSService(this.setUpDNSServer("local"));
        ((AbstractListAssert)Assertions.assertThat((List)dom.getDomains()).describedAs("Two domains found", new Object[0])).hasSize(2);
    }

    @Test
    public void testGetDomainsAutoDetectLocalHost() throws Exception {
        ArrayList<String> domains = new ArrayList<String>();
        domains.add("domain1.");
        XMLDomainList dom = new XMLDomainList();
        dom.setLog(LoggerFactory.getLogger((String)"MockLog"));
        dom.configure(this.setUpConfiguration(true, false, domains));
        dom.setDNSService(this.setUpDNSServer("localhost"));
        ((AbstractListAssert)Assertions.assertThat((List)dom.getDomains()).describedAs("One domain found", new Object[0])).hasSize(1);
    }

    @Test
    public void addDomainShouldFailWhenAlreadyConfigured() throws Exception {
        this.expectedException.expect(DomainListException.class);
        ArrayList<String> domains = new ArrayList<String>();
        domains.add("domain1");
        XMLDomainList testee = new XMLDomainList();
        testee.setLog(LoggerFactory.getLogger((String)"MockLog"));
        testee.configure(this.setUpConfiguration(true, false, domains));
        testee.addDomain("newDomain");
    }

    @Test
    public void removeDomainShouldFailWhenAlreadyConfigured() throws Exception {
        this.expectedException.expect(DomainListException.class);
        ArrayList<String> domains = new ArrayList<String>();
        domains.add("domain1");
        XMLDomainList testee = new XMLDomainList();
        testee.setLog(LoggerFactory.getLogger((String)"MockLog"));
        testee.configure(this.setUpConfiguration(true, false, domains));
        testee.removeDomain("newDomain");
    }

    @Test
    public void configureShouldNotFailWhenConfiguringDefaultDomain() throws Exception {
        DefaultConfigurationBuilder configuration = new DefaultConfigurationBuilder();
        configuration.addProperty("autodetect", (Object)true);
        configuration.addProperty("autodetectIP", (Object)false);
        configuration.addProperty("domainnames.domainname", (Object)"domain1");
        configuration.addProperty("defaultDomain", (Object)"localhost");
        XMLDomainList testee = new XMLDomainList();
        testee.setLog(LoggerFactory.getLogger((String)"MockLog"));
        testee.configure((HierarchicalConfiguration)configuration);
        Assertions.assertThat((List)testee.getDomainListInternal()).hasSize(2);
    }
}

