/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vacation.api;

import java.time.ZonedDateTime;
import java.util.Optional;
import org.apache.james.vacation.api.Vacation;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class VacationTest {
    static final ZonedDateTime DATE_TIME_2016 = ZonedDateTime.parse("2016-10-09T08:07:06+07:00[Asia/Vientiane]");
    static final ZonedDateTime DATE_TIME_2017 = ZonedDateTime.parse("2017-10-09T08:07:06+07:00[Asia/Vientiane]");
    static final ZonedDateTime DATE_TIME_2017_1MS = ZonedDateTime.parse("2017-10-09T08:07:06.001+07:00[Asia/Vientiane]");
    static final ZonedDateTime DATE_TIME_2018 = ZonedDateTime.parse("2018-10-09T08:07:06+07:00[Asia/Vientiane]");
    static final String TEXT_BODY = "text is required when enabled";
    static final String HTML_BODY = "<b>HTML body</b>";

    VacationTest() {
    }

    @Test
    void disabledVacationsAreNotActive() {
        Assertions.assertThat((boolean)Vacation.builder().enabled(false).build().isActiveAtDate(DATE_TIME_2016)).isFalse();
    }

    @Test
    void enabledVacationWithoutDatesIsActive() {
        Assertions.assertThat((boolean)Vacation.builder().enabled(true).textBody(TEXT_BODY).build().isActiveAtDate(DATE_TIME_2016)).isTrue();
    }

    @Test
    void rangeShouldBeInclusiveOnFromDate() {
        Assertions.assertThat((boolean)Vacation.builder().enabled(true).textBody(TEXT_BODY).fromDate(Optional.of(DATE_TIME_2016)).build().isActiveAtDate(DATE_TIME_2016)).isTrue();
    }

    @Test
    void rangeShouldBeInclusiveOnToDate() {
        Assertions.assertThat((boolean)Vacation.builder().enabled(true).textBody(TEXT_BODY).toDate(Optional.of(DATE_TIME_2016)).build().isActiveAtDate(DATE_TIME_2016)).isTrue();
    }

    @Test
    void vacationShouldBeActiveDuringRange() {
        Assertions.assertThat((boolean)Vacation.builder().enabled(true).textBody(TEXT_BODY).fromDate(Optional.of(DATE_TIME_2016)).toDate(Optional.of(DATE_TIME_2018)).build().isActiveAtDate(DATE_TIME_2017)).isTrue();
    }

    @Test
    void vacationShouldNotBeActiveAfterRange() {
        Assertions.assertThat((boolean)Vacation.builder().enabled(true).textBody(TEXT_BODY).fromDate(Optional.of(DATE_TIME_2016)).toDate(Optional.of(DATE_TIME_2017)).build().isActiveAtDate(DATE_TIME_2018)).isFalse();
    }

    @Test
    void vacationShouldNotBeActiveBeforeRange() {
        Assertions.assertThat((boolean)Vacation.builder().enabled(true).textBody(TEXT_BODY).fromDate(Optional.of(DATE_TIME_2017)).toDate(Optional.of(DATE_TIME_2018)).build().isActiveAtDate(DATE_TIME_2016)).isFalse();
    }

    @Test
    void isActiveAtDateShouldThrowOnNullValue() {
        Assertions.assertThatThrownBy(() -> Vacation.builder().enabled(true).textBody(TEXT_BODY).fromDate(Optional.of(DATE_TIME_2016)).toDate(Optional.of(DATE_TIME_2016)).build().isActiveAtDate(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void vacationShouldBeActiveAfterFromDate() {
        Assertions.assertThat((boolean)Vacation.builder().enabled(true).textBody(TEXT_BODY).fromDate(Optional.of(DATE_TIME_2016)).build().isActiveAtDate(DATE_TIME_2017)).isTrue();
    }

    @Test
    void vacationShouldNotBeActiveBeforeFromDate() {
        Assertions.assertThat((boolean)Vacation.builder().enabled(true).textBody(TEXT_BODY).fromDate(Optional.of(DATE_TIME_2017)).build().isActiveAtDate(DATE_TIME_2016)).isFalse();
    }

    @Test
    void vacationShouldNotBeActiveAfterToDate() {
        Assertions.assertThat((boolean)Vacation.builder().enabled(true).textBody(TEXT_BODY).toDate(Optional.of(DATE_TIME_2017)).build().isActiveAtDate(DATE_TIME_2018)).isFalse();
    }

    @Test
    void vacationShouldBeActiveBeforeToDate() {
        Assertions.assertThat((boolean)Vacation.builder().enabled(true).textBody(TEXT_BODY).toDate(Optional.of(DATE_TIME_2017)).build().isActiveAtDate(DATE_TIME_2016)).isTrue();
    }

    @Test
    void isActiveAtDateShouldHaveMillisecondPrecision() {
        Assertions.assertThat((boolean)Vacation.builder().enabled(true).textBody(TEXT_BODY).toDate(Optional.of(DATE_TIME_2017)).build().isActiveAtDate(DATE_TIME_2017_1MS)).isFalse();
    }

    @Test
    void textBodyShouldBeEnoughToBuildAnActivatedVacation() {
        Assertions.assertThat((Optional)Vacation.builder().enabled(true).textBody(TEXT_BODY).build().getTextBody()).contains((Object)TEXT_BODY);
    }

    @Test
    void htmlBodyShouldBeEnoughToBuildAnActivatedVacation() {
        Assertions.assertThat((Optional)Vacation.builder().enabled(true).htmlBody(HTML_BODY).build().getHtmlBody()).contains((Object)HTML_BODY);
    }

    @Test
    void textOrHtmlBodyShouldNotBeRequiredOnUnactivatedVacation() {
        Assertions.assertThat((boolean)Vacation.builder().enabled(false).build().isEnabled()).isFalse();
    }
}

