/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vacation.api;

import java.time.ZonedDateTime;
import java.util.Optional;
import org.apache.james.util.ValuePatch;
import org.apache.james.vacation.api.AccountId;
import org.apache.james.vacation.api.Vacation;
import org.apache.james.vacation.api.VacationPatch;
import org.apache.james.vacation.api.VacationRepository;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public interface VacationRepositoryContract {
    public static final AccountId ACCOUNT_ID = AccountId.fromString((String)"identifier");
    public static final ZonedDateTime DATE_2014 = ZonedDateTime.parse("2014-04-03T02:01+07:00[Asia/Vientiane]");
    public static final ZonedDateTime DATE_2015 = ZonedDateTime.parse("2015-04-03T02:01+07:00[Asia/Vientiane]");
    public static final ZonedDateTime DATE_2016 = ZonedDateTime.parse("2016-04-03T02:01+07:00[Asia/Vientiane]");
    public static final ZonedDateTime DATE_2017 = ZonedDateTime.parse("2017-04-03T02:01+07:00[Asia/Vientiane]");
    public static final Vacation VACATION = Vacation.builder().fromDate(Optional.of(DATE_2015)).toDate(Optional.of(DATE_2016)).enabled(true).subject(Optional.of("subject")).textBody("anyMessage").htmlBody("html Message").build();

    public VacationRepository vacationRepository();

    @Test
    default public void retrieveVacationShouldReturnDefaultValueByDefault() {
        Assertions.assertThat((Object)((Vacation)this.vacationRepository().retrieveVacation(ACCOUNT_ID).block())).isEqualTo((Object)VacationRepository.DEFAULT_VACATION);
    }

    @Test
    default public void modifyVacationShouldUpdateEnabled() {
        VacationPatch vacationPatch = VacationPatch.builder().isEnabled(Boolean.valueOf(true)).build();
        this.vacationRepository().modifyVacation(ACCOUNT_ID, vacationPatch).block();
        Assertions.assertThat((Object)((Vacation)this.vacationRepository().retrieveVacation(ACCOUNT_ID).block())).isEqualTo((Object)Vacation.builder().enabled(true).build());
    }

    @Test
    default public void modifyVacationShouldUpdateFromDate() {
        VacationPatch vacationPatch = VacationPatch.builder().fromDate(DATE_2014).build();
        this.vacationRepository().modifyVacation(ACCOUNT_ID, vacationPatch).block();
        Assertions.assertThat((Object)((Vacation)this.vacationRepository().retrieveVacation(ACCOUNT_ID).block())).isEqualTo((Object)Vacation.builder().fromDate(Optional.of(DATE_2014)).enabled(false).build());
    }

    @Test
    default public void modifyVacationShouldUpdateToDate() {
        VacationPatch vacationPatch = VacationPatch.builder().toDate(DATE_2017).build();
        this.vacationRepository().modifyVacation(ACCOUNT_ID, vacationPatch).block();
        Assertions.assertThat((Object)((Vacation)this.vacationRepository().retrieveVacation(ACCOUNT_ID).block())).isEqualTo((Object)Vacation.builder().toDate(Optional.of(DATE_2017)).enabled(false).build());
    }

    @Test
    default public void modifyVacationShouldUpdateSubject() {
        String newSubject = "new subject";
        VacationPatch vacationPatch = VacationPatch.builder().subject(newSubject).build();
        this.vacationRepository().modifyVacation(ACCOUNT_ID, vacationPatch).block();
        Assertions.assertThat((Object)((Vacation)this.vacationRepository().retrieveVacation(ACCOUNT_ID).block())).isEqualTo((Object)Vacation.builder().subject(Optional.of(newSubject)).enabled(false).build());
    }

    @Test
    default public void modifyVacationShouldUpdateTextBody() {
        String newTextBody = "new text body";
        VacationPatch vacationPatch = VacationPatch.builder().textBody(newTextBody).build();
        this.vacationRepository().modifyVacation(ACCOUNT_ID, vacationPatch).block();
        Assertions.assertThat((Object)((Vacation)this.vacationRepository().retrieveVacation(ACCOUNT_ID).block())).isEqualTo((Object)Vacation.builder().textBody(newTextBody).enabled(false).build());
    }

    @Test
    default public void modifyVacationShouldUpdateHtmlBody() {
        String newHtmlBody = "new <b>html</b> body";
        VacationPatch vacationPatch = VacationPatch.builder().htmlBody(newHtmlBody).build();
        this.vacationRepository().modifyVacation(ACCOUNT_ID, vacationPatch).block();
        Assertions.assertThat((Object)((Vacation)this.vacationRepository().retrieveVacation(ACCOUNT_ID).block())).isEqualTo((Object)Vacation.builder().enabled(false).htmlBody(newHtmlBody).build());
    }

    @Test
    default public void modifyVacationShouldAllowToUpdateAllFieldsAtOnce() {
        VacationPatch vacationPatch = VacationPatch.builderFrom((Vacation)VACATION).build();
        this.vacationRepository().modifyVacation(ACCOUNT_ID, vacationPatch).block();
        Assertions.assertThat((Object)((Vacation)this.vacationRepository().retrieveVacation(ACCOUNT_ID).block())).isEqualTo((Object)VACATION);
    }

    @Test
    default public void modifyVacationShouldAllowEmptyUpdates() {
        VacationPatch vacationPatch = VacationPatch.builder().build();
        this.vacationRepository().modifyVacation(ACCOUNT_ID, vacationPatch).block();
        Assertions.assertThat((Object)((Vacation)this.vacationRepository().retrieveVacation(ACCOUNT_ID).block())).isEqualTo((Object)VacationRepository.DEFAULT_VACATION);
    }

    @Test
    default public void emptyUpdatesShouldNotChangeExistingVacations() {
        this.vacationRepository().modifyVacation(ACCOUNT_ID, VacationPatch.builderFrom((Vacation)VACATION).build()).block();
        this.vacationRepository().modifyVacation(ACCOUNT_ID, VacationPatch.builder().build()).block();
        Assertions.assertThat((Object)((Vacation)this.vacationRepository().retrieveVacation(ACCOUNT_ID).block())).isEqualTo((Object)VACATION);
    }

    @Test
    default public void nullUpdateShouldResetSubject() {
        this.vacationRepository().modifyVacation(ACCOUNT_ID, VacationPatch.builderFrom((Vacation)VACATION).build()).block();
        this.vacationRepository().modifyVacation(ACCOUNT_ID, VacationPatch.builder().subject(ValuePatch.remove()).build()).block();
        Vacation vacation = (Vacation)this.vacationRepository().retrieveVacation(ACCOUNT_ID).block();
        Assertions.assertThat((Optional)vacation.getSubject()).isEmpty();
        Assertions.assertThat((Object)vacation).isEqualTo((Object)Vacation.builder().fromDate(VACATION.getFromDate()).toDate(VACATION.getToDate()).enabled(VACATION.isEnabled()).textBody(VACATION.getTextBody()).htmlBody(VACATION.getHtmlBody()).build());
    }

    @Test
    default public void nullUpdateShouldResetText() {
        this.vacationRepository().modifyVacation(ACCOUNT_ID, VacationPatch.builderFrom((Vacation)VACATION).build()).block();
        this.vacationRepository().modifyVacation(ACCOUNT_ID, VacationPatch.builder().textBody(ValuePatch.remove()).build()).block();
        Vacation vacation = (Vacation)this.vacationRepository().retrieveVacation(ACCOUNT_ID).block();
        Assertions.assertThat((Optional)vacation.getTextBody()).isEmpty();
        Assertions.assertThat((Object)vacation).isEqualTo((Object)Vacation.builder().fromDate(VACATION.getFromDate()).toDate(VACATION.getToDate()).enabled(VACATION.isEnabled()).subject(VACATION.getSubject()).htmlBody(VACATION.getHtmlBody()).build());
    }

    @Test
    default public void nullUpdateShouldResetHtml() {
        this.vacationRepository().modifyVacation(ACCOUNT_ID, VacationPatch.builderFrom((Vacation)VACATION).build()).block();
        this.vacationRepository().modifyVacation(ACCOUNT_ID, VacationPatch.builder().htmlBody(ValuePatch.remove()).build()).block();
        Vacation vacation = (Vacation)this.vacationRepository().retrieveVacation(ACCOUNT_ID).block();
        Assertions.assertThat((Optional)vacation.getHtmlBody()).isEmpty();
        Assertions.assertThat((Object)vacation).isEqualTo((Object)Vacation.builder().fromDate(VACATION.getFromDate()).toDate(VACATION.getToDate()).enabled(VACATION.isEnabled()).subject(VACATION.getSubject()).textBody(VACATION.getTextBody()).build());
    }

    @Test
    default public void nullUpdateShouldResetToDate() {
        this.vacationRepository().modifyVacation(ACCOUNT_ID, VacationPatch.builderFrom((Vacation)VACATION).build()).block();
        this.vacationRepository().modifyVacation(ACCOUNT_ID, VacationPatch.builder().toDate(ValuePatch.remove()).build()).block();
        Vacation vacation = (Vacation)this.vacationRepository().retrieveVacation(ACCOUNT_ID).block();
        Assertions.assertThat((Optional)vacation.getToDate()).isEmpty();
        Assertions.assertThat((Object)vacation).isEqualTo((Object)Vacation.builder().fromDate(VACATION.getFromDate()).enabled(VACATION.isEnabled()).subject(VACATION.getSubject()).textBody(VACATION.getTextBody()).htmlBody(VACATION.getHtmlBody()).build());
    }

    @Test
    default public void nullUpdateShouldResetFromDate() {
        this.vacationRepository().modifyVacation(ACCOUNT_ID, VacationPatch.builderFrom((Vacation)VACATION).build()).block();
        this.vacationRepository().modifyVacation(ACCOUNT_ID, VacationPatch.builder().fromDate(ValuePatch.remove()).build()).block();
        Vacation vacation = (Vacation)this.vacationRepository().retrieveVacation(ACCOUNT_ID).block();
        Assertions.assertThat((Optional)vacation.getFromDate()).isEmpty();
        Assertions.assertThat((Object)vacation).isEqualTo((Object)Vacation.builder().toDate(VACATION.getToDate()).enabled(VACATION.isEnabled()).subject(VACATION.getSubject()).textBody(VACATION.getTextBody()).htmlBody(VACATION.getHtmlBody()).build());
    }

    @Test
    default public void retrieveVacationShouldThrowOnNullAccountId() {
        Assertions.assertThatThrownBy(() -> this.vacationRepository().retrieveVacation(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    default public void modifyVacationShouldThrowOnNullAccountId() {
        Assertions.assertThatThrownBy(() -> this.vacationRepository().modifyVacation(null, VacationPatch.builder().build())).isInstanceOf(NullPointerException.class);
    }

    @Test
    default public void modifyVacationShouldThrowOnNullVacation() {
        Assertions.assertThatThrownBy(() -> this.vacationRepository().modifyVacation(ACCOUNT_ID, null)).isInstanceOf(NullPointerException.class);
    }
}

