/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vacation.api;

import java.time.ZonedDateTime;
import java.util.Optional;
import org.apache.james.util.ValuePatch;
import org.apache.james.vacation.api.Vacation;
import org.apache.james.vacation.api.VacationPatch;
import org.apache.james.vacation.api.VacationRepository;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class VacationPatchTest {
    static final ZonedDateTime DATE_2014 = ZonedDateTime.parse("2014-04-03T02:01+07:00[Asia/Vientiane]");
    static final ZonedDateTime DATE_2015 = ZonedDateTime.parse("2015-04-03T02:01+07:00[Asia/Vientiane]");
    static final ZonedDateTime DATE_2017 = ZonedDateTime.parse("2017-04-03T02:01+07:00[Asia/Vientiane]");
    static final Vacation VACATION = Vacation.builder().fromDate(Optional.of(DATE_2014)).toDate(Optional.of(DATE_2015)).enabled(true).subject(Optional.of("subject")).textBody("anyMessage").htmlBody("html Message").build();

    VacationPatchTest() {
    }

    @Test
    void fromDateShouldThrowNPEOnNullInput() {
        Assertions.assertThatThrownBy(() -> VacationPatch.builder().fromDate((ValuePatch)null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void toDateShouldThrowNPEOnNullInput() {
        Assertions.assertThatThrownBy(() -> VacationPatch.builder().toDate((ValuePatch)null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void textBodyShouldThrowNPEOnNullInput() {
        Assertions.assertThatThrownBy(() -> VacationPatch.builder().textBody((ValuePatch)null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void htmlBodyShouldThrowNPEOnNullInput() {
        Assertions.assertThatThrownBy(() -> VacationPatch.builder().htmlBody((ValuePatch)null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void subjectShouldThrowNPEOnNullInput() {
        Assertions.assertThatThrownBy(() -> VacationPatch.builder().subject((ValuePatch)null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void isEnabledShouldThrowNPEOnNullInput() {
        Assertions.assertThatThrownBy(() -> VacationPatch.builder().isEnabled((ValuePatch)null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void isIdentityShouldBeTrueWhenUpdateIsEmpty() {
        Assertions.assertThat((boolean)VacationPatch.builder().build().isIdentity()).isTrue();
    }

    @Test
    void isIdentityShouldBeFalseWhenUpdateIsNotEmpty() {
        Assertions.assertThat((boolean)VacationPatch.builder().subject(ValuePatch.modifyTo((Object)"any subject")).build().isIdentity()).isFalse();
    }

    @Test
    void builderShouldWellSetFields() {
        ValuePatch subject = ValuePatch.modifyTo((Object)"subject");
        ValuePatch htmlBody = ValuePatch.modifyTo((Object)"html text");
        ValuePatch textBody = ValuePatch.modifyTo((Object)"simple text");
        ValuePatch isEnabled = ValuePatch.modifyTo((Object)true);
        VacationPatch update = VacationPatch.builder().fromDate(ValuePatch.modifyTo((Object)DATE_2014)).toDate(ValuePatch.modifyTo((Object)DATE_2015)).subject(subject).htmlBody(htmlBody).textBody(textBody).isEnabled(isEnabled).build();
        Assertions.assertThat((Object)update.getFromDate()).isEqualTo((Object)ValuePatch.modifyTo((Object)DATE_2014));
        Assertions.assertThat((Object)update.getToDate()).isEqualTo((Object)ValuePatch.modifyTo((Object)DATE_2015));
        Assertions.assertThat((Object)update.getSubject()).isEqualTo((Object)subject);
        Assertions.assertThat((Object)update.getHtmlBody()).isEqualTo((Object)htmlBody);
        Assertions.assertThat((Object)update.getTextBody()).isEqualTo((Object)textBody);
        Assertions.assertThat((Object)update.getIsEnabled()).isEqualTo((Object)isEnabled);
    }

    @Test
    void patchVacationShouldUpdateEnabled() {
        VacationPatch vacationPatch = VacationPatch.builder().isEnabled(ValuePatch.modifyTo((Object)true)).build();
        Assertions.assertThat((Object)vacationPatch.patch(VacationRepository.DEFAULT_VACATION)).isEqualTo((Object)Vacation.builder().enabled(true).build());
    }

    @Test
    void patchVacationShouldUpdateFromDate() {
        VacationPatch vacationPatch = VacationPatch.builder().fromDate(ValuePatch.modifyTo((Object)DATE_2014)).build();
        Assertions.assertThat((Object)vacationPatch.patch(VacationRepository.DEFAULT_VACATION)).isEqualTo((Object)Vacation.builder().fromDate(Optional.of(DATE_2014)).enabled(false).build());
    }

    @Test
    void patchVacationShouldUpdateToDate() {
        VacationPatch vacationPatch = VacationPatch.builder().toDate(ValuePatch.modifyTo((Object)DATE_2017)).build();
        Assertions.assertThat((Object)vacationPatch.patch(VacationRepository.DEFAULT_VACATION)).isEqualTo((Object)Vacation.builder().toDate(Optional.of(DATE_2017)).enabled(false).build());
    }

    @Test
    void patchVacationShouldUpdateSubject() {
        String newSubject = "new subject";
        VacationPatch vacationPatch = VacationPatch.builder().subject(ValuePatch.modifyTo((Object)newSubject)).build();
        Assertions.assertThat((Object)vacationPatch.patch(VacationRepository.DEFAULT_VACATION)).isEqualTo((Object)Vacation.builder().subject(Optional.of(newSubject)).enabled(false).build());
    }

    @Test
    void patchVacationShouldUpdateTextBody() {
        String newTextBody = "new text body";
        VacationPatch vacationPatch = VacationPatch.builder().textBody(ValuePatch.modifyTo((Object)newTextBody)).build();
        Assertions.assertThat((Object)vacationPatch.patch(VacationRepository.DEFAULT_VACATION)).isEqualTo((Object)Vacation.builder().textBody(newTextBody).enabled(false).build());
    }

    @Test
    void patchVacationShouldUpdateHtmlBody() {
        String newHtmlBody = "new <b>html</b> body";
        VacationPatch vacationPatch = VacationPatch.builder().htmlBody(ValuePatch.modifyTo((Object)newHtmlBody)).build();
        Assertions.assertThat((Object)vacationPatch.patch(VacationRepository.DEFAULT_VACATION)).isEqualTo((Object)Vacation.builder().enabled(false).htmlBody(newHtmlBody).build());
    }

    @Test
    void patchVacationShouldAllowToUpdateAllFieldsAtOnce() {
        VacationPatch vacationPatch = VacationPatch.builder().subject(ValuePatch.ofOptional((Optional)VACATION.getSubject())).textBody(ValuePatch.ofOptional((Optional)VACATION.getTextBody())).htmlBody(ValuePatch.ofOptional((Optional)VACATION.getHtmlBody())).fromDate(ValuePatch.ofOptional((Optional)VACATION.getFromDate())).toDate(ValuePatch.ofOptional((Optional)VACATION.getToDate())).isEnabled(ValuePatch.modifyTo((Object)VACATION.isEnabled())).build();
        Assertions.assertThat((Object)vacationPatch.patch(VacationRepository.DEFAULT_VACATION)).isEqualTo((Object)VACATION);
    }

    @Test
    void emptyPatchesShouldNotChangeExistingVacations() {
        Assertions.assertThat((Object)VacationPatch.builder().build().patch(VACATION)).isEqualTo((Object)VACATION);
    }

    @Test
    void nullUpdateShouldResetSubject() {
        Vacation vacation = VacationPatch.builderFrom((Vacation)VACATION).subject(ValuePatch.remove()).build().patch(VACATION);
        Assertions.assertThat((Optional)vacation.getSubject()).isEmpty();
        Assertions.assertThat((Object)vacation).isEqualTo((Object)Vacation.builder().fromDate(VACATION.getFromDate()).toDate(VACATION.getToDate()).enabled(VACATION.isEnabled()).textBody(VACATION.getTextBody()).htmlBody(VACATION.getHtmlBody()).build());
    }

    @Test
    void nullUpdateShouldResetText() {
        Vacation vacation = VacationPatch.builderFrom((Vacation)VACATION).textBody(ValuePatch.remove()).build().patch(VACATION);
        Assertions.assertThat((Optional)vacation.getTextBody()).isEmpty();
        Assertions.assertThat((Object)vacation).isEqualTo((Object)Vacation.builder().fromDate(VACATION.getFromDate()).toDate(VACATION.getToDate()).enabled(VACATION.isEnabled()).subject(VACATION.getSubject()).htmlBody(VACATION.getHtmlBody()).build());
    }

    @Test
    void nullUpdateShouldResetHtml() {
        Vacation vacation = VacationPatch.builderFrom((Vacation)VACATION).htmlBody(ValuePatch.remove()).build().patch(VACATION);
        Assertions.assertThat((Optional)vacation.getHtmlBody()).isEmpty();
        Assertions.assertThat((Object)vacation).isEqualTo((Object)Vacation.builder().fromDate(VACATION.getFromDate()).toDate(VACATION.getToDate()).enabled(VACATION.isEnabled()).subject(VACATION.getSubject()).textBody(VACATION.getTextBody()).build());
    }

    @Test
    void nullUpdateShouldResetToDate() {
        Vacation vacation = VacationPatch.builderFrom((Vacation)VACATION).toDate(ValuePatch.remove()).build().patch(VACATION);
        Assertions.assertThat((Optional)vacation.getToDate()).isEmpty();
        Assertions.assertThat((Object)vacation).isEqualTo((Object)Vacation.builder().fromDate(VACATION.getFromDate()).enabled(VACATION.isEnabled()).subject(VACATION.getSubject()).textBody(VACATION.getTextBody()).htmlBody(VACATION.getHtmlBody()).build());
    }

    @Test
    void nullUpdateShouldResetFromDate() {
        Vacation vacation = VacationPatch.builderFrom((Vacation)VACATION).fromDate(ValuePatch.remove()).build().patch(VACATION);
        Assertions.assertThat((Optional)vacation.getFromDate()).isEmpty();
        Assertions.assertThat((Object)vacation).isEqualTo((Object)Vacation.builder().toDate(VACATION.getToDate()).enabled(VACATION.isEnabled()).subject(VACATION.getSubject()).textBody(VACATION.getTextBody()).htmlBody(VACATION.getHtmlBody()).build());
    }
}

