/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vacation.api;

import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.james.util.date.ZonedDateTimeProvider;
import org.apache.james.vacation.api.AccountId;
import org.apache.james.vacation.api.NotificationRegistry;
import org.apache.james.vacation.api.RecipientId;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public interface NotificationRegistryContract {
    public static final ZonedDateTime ZONED_DATE_TIME = ZonedDateTime.parse("2016-04-03T02:01:01+07:00[Asia/Vientiane]");
    public static final ZonedDateTime ZONED_DATE_TIME_PLUS_4_SECONDS = ZonedDateTime.parse("2016-04-03T02:01:05+07:00[Asia/Vientiane]");
    public static final ZonedDateTime ZONED_DATE_TIME_PLUS_8_SECONDS = ZonedDateTime.parse("2016-04-03T02:01:09+07:00[Asia/Vientiane]");
    public static final AccountId ACCOUNT_ID = AccountId.fromString((String)"id");
    public static final ZonedDateTimeProvider zonedDateTimeProvider = (ZonedDateTimeProvider)Mockito.mock(ZonedDateTimeProvider.class);

    public NotificationRegistry notificationRegistry();

    public RecipientId recipientId();

    @Test
    default public void isRegisterShouldReturnFalseByDefault() {
        Assertions.assertThat((Boolean)((Boolean)this.notificationRegistry().isRegistered(ACCOUNT_ID, this.recipientId()).block())).isFalse();
    }

    @Test
    default public void registerShouldWork() {
        this.notificationRegistry().register(ACCOUNT_ID, this.recipientId(), Optional.empty()).block();
        Assertions.assertThat((Boolean)((Boolean)this.notificationRegistry().isRegistered(ACCOUNT_ID, this.recipientId()).block())).isTrue();
    }

    @Test
    default public void registerShouldWorkWithExpiracyDate() {
        Mockito.when((Object)((ZonedDateTime)zonedDateTimeProvider.get())).thenReturn((Object)ZONED_DATE_TIME);
        this.notificationRegistry().register(ACCOUNT_ID, this.recipientId(), Optional.of(ZONED_DATE_TIME_PLUS_4_SECONDS)).block();
        Assertions.assertThat((Boolean)((Boolean)this.notificationRegistry().isRegistered(ACCOUNT_ID, this.recipientId()).block())).isTrue();
    }

    @Test
    default public void registerShouldExpireAfterExpiracyDate() {
        Mockito.when((Object)((ZonedDateTime)zonedDateTimeProvider.get())).thenReturn((Object)ZONED_DATE_TIME);
        this.notificationRegistry().register(ACCOUNT_ID, this.recipientId(), Optional.of(ZONED_DATE_TIME_PLUS_4_SECONDS)).block();
        Mockito.when((Object)((ZonedDateTime)zonedDateTimeProvider.get())).thenReturn((Object)ZONED_DATE_TIME_PLUS_8_SECONDS);
        Awaitility.await().atMost(20L, TimeUnit.SECONDS).until(() -> (Boolean)this.notificationRegistry().isRegistered(ACCOUNT_ID, this.recipientId()).block() == false);
    }

    @Test
    default public void flushShouldWork() {
        Mockito.when((Object)((ZonedDateTime)zonedDateTimeProvider.get())).thenReturn((Object)ZONED_DATE_TIME);
        this.notificationRegistry().register(ACCOUNT_ID, this.recipientId(), Optional.empty()).block();
        this.notificationRegistry().flush(ACCOUNT_ID).block();
        Assertions.assertThat((Boolean)((Boolean)this.notificationRegistry().isRegistered(ACCOUNT_ID, this.recipientId()).block())).isFalse();
    }

    @Test
    default public void registerShouldNotPersistWhenExpiryDateIsPast() {
        Mockito.when((Object)((ZonedDateTime)zonedDateTimeProvider.get())).thenReturn((Object)ZONED_DATE_TIME_PLUS_4_SECONDS);
        this.notificationRegistry().register(ACCOUNT_ID, this.recipientId(), Optional.of(ZONED_DATE_TIME)).block();
        Assertions.assertThat((Boolean)((Boolean)this.notificationRegistry().isRegistered(ACCOUNT_ID, this.recipientId()).block())).isFalse();
    }

    @Test
    default public void registerShouldNotPersistWhenExpiryDateIsPresent() {
        Mockito.when((Object)((ZonedDateTime)zonedDateTimeProvider.get())).thenReturn((Object)ZONED_DATE_TIME);
        this.notificationRegistry().register(ACCOUNT_ID, this.recipientId(), Optional.of(ZONED_DATE_TIME)).block();
        Assertions.assertThat((Boolean)((Boolean)this.notificationRegistry().isRegistered(ACCOUNT_ID, this.recipientId()).block())).isTrue();
    }
}

