/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vacation.api;

import org.apache.james.vacation.api.AccountId;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class AccountIdTest {
    static final String IDENTIFIER = "id";

    AccountIdTest() {
    }

    @Test
    void createShouldThrowOnNullIdentifier() {
        Assertions.assertThatThrownBy(() -> AccountId.fromString(null)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void createShouldThrowOnEmptyIdentifier() {
        Assertions.assertThatThrownBy(() -> AccountId.fromString((String)"")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void createShouldWork() {
        Assertions.assertThat((String)AccountId.fromString((String)IDENTIFIER).getIdentifier()).isEqualTo(IDENTIFIER);
    }
}

