/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.api;

import java.util.List;
import org.apache.james.core.Username;
import org.apache.james.user.api.DelegationStore;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface DelegationStoreContract {
    public static final Username ALICE = Username.of((String)"alice");
    public static final Username BOB = Username.of((String)"bob");
    public static final Username CEDRIC = Username.of((String)"cedic");
    public static final Username DAMIEN = Username.of((String)"damien");
    public static final Username EDGARD = Username.of((String)"edgard");

    public DelegationStore testee();

    default public void addUser(Username username) {
    }

    @Test
    default public void authorizedUsersShouldReturnEmptyByDefault() {
        Assertions.assertThat((List)((List)Flux.from((Publisher)this.testee().authorizedUsers(ALICE)).collectList().block())).isEmpty();
    }

    @Test
    default public void authorizedUsersShouldReturnAddedUsers() {
        Mono.from((Publisher)this.testee().addAuthorizedUser(ALICE, BOB)).block();
        Mono.from((Publisher)this.testee().addAuthorizedUser(ALICE, CEDRIC)).block();
        Mono.from((Publisher)this.testee().addAuthorizedUser(ALICE, DAMIEN)).block();
        Assertions.assertThat((List)((List)Flux.from((Publisher)this.testee().authorizedUsers(ALICE)).collectList().block())).containsOnly((Object[])new Username[]{BOB, CEDRIC, DAMIEN});
    }

    @Test
    default public void authorizedUsersShouldReturnEmptyAfterClear() {
        Mono.from((Publisher)this.testee().addAuthorizedUser(ALICE, BOB)).block();
        Mono.from((Publisher)this.testee().addAuthorizedUser(ALICE, CEDRIC)).block();
        Mono.from((Publisher)this.testee().addAuthorizedUser(ALICE, DAMIEN)).block();
        Mono.from((Publisher)this.testee().clear(ALICE)).block();
        Assertions.assertThat((List)((List)Flux.from((Publisher)this.testee().authorizedUsers(ALICE)).collectList().block())).isEmpty();
    }

    @Test
    default public void clearShouldBeIdempotent() {
        this.addUser(BOB);
        Mono.from((Publisher)this.testee().addAuthorizedUser(EDGARD, BOB)).block();
        Mono.from((Publisher)this.testee().addAuthorizedUser(ALICE, BOB)).block();
        Mono.from((Publisher)this.testee().addAuthorizedUser(ALICE, CEDRIC)).block();
        Mono.from((Publisher)this.testee().addAuthorizedUser(ALICE, DAMIEN)).block();
        Mono.from((Publisher)this.testee().clear(ALICE)).block();
        Mono.from((Publisher)this.testee().clear(ALICE)).block();
        Assertions.assertThat((List)((List)Flux.from((Publisher)this.testee().authorizedUsers(ALICE)).collectList().block())).isEmpty();
        Assertions.assertThat((List)((List)Flux.from((Publisher)this.testee().delegatedUsers(BOB)).collectList().block())).containsExactly((Object[])new Username[]{EDGARD});
    }

    @Test
    default public void authorizedUsersShouldNotReturnDeletedUsers() {
        Mono.from((Publisher)this.testee().addAuthorizedUser(ALICE, BOB)).block();
        Mono.from((Publisher)this.testee().addAuthorizedUser(ALICE, CEDRIC)).block();
        Mono.from((Publisher)this.testee().addAuthorizedUser(ALICE, DAMIEN)).block();
        Mono.from((Publisher)this.testee().removeAuthorizedUser(ALICE, CEDRIC)).block();
        Assertions.assertThat((List)((List)Flux.from((Publisher)this.testee().authorizedUsers(ALICE)).collectList().block())).containsOnly((Object[])new Username[]{BOB, DAMIEN});
    }

    @Test
    default public void removeAuthorizedUserShouldBeIdempotent() {
        this.addUser(CEDRIC);
        Mono.from((Publisher)this.testee().addAuthorizedUser(ALICE, BOB)).block();
        Mono.from((Publisher)this.testee().addAuthorizedUser(ALICE, CEDRIC)).block();
        Mono.from((Publisher)this.testee().addAuthorizedUser(ALICE, DAMIEN)).block();
        Mono.from((Publisher)this.testee().addAuthorizedUser(EDGARD, CEDRIC)).block();
        Mono.from((Publisher)this.testee().removeAuthorizedUser(ALICE, CEDRIC)).block();
        Mono.from((Publisher)this.testee().removeAuthorizedUser(ALICE, CEDRIC)).block();
        Assertions.assertThat((List)((List)Flux.from((Publisher)this.testee().authorizedUsers(ALICE)).collectList().block())).containsOnly((Object[])new Username[]{BOB, DAMIEN});
        Assertions.assertThat((List)((List)Flux.from((Publisher)this.testee().delegatedUsers(CEDRIC)).collectList().block())).containsOnly((Object[])new Username[]{EDGARD});
    }

    @Test
    default public void authorizedUsersShouldNotReturnDuplicates() {
        Mono.from((Publisher)this.testee().addAuthorizedUser(ALICE, BOB)).block();
        Mono.from((Publisher)this.testee().addAuthorizedUser(ALICE, BOB)).block();
        Assertions.assertThat((List)((List)Flux.from((Publisher)this.testee().authorizedUsers(ALICE)).collectList().block())).containsExactly((Object[])new Username[]{BOB});
    }

    @Test
    default public void authorizedUsersShouldNotReturnUnrelatedUsers() {
        Mono.from((Publisher)this.testee().addAuthorizedUser(BOB, ALICE)).block();
        Mono.from((Publisher)this.testee().addAuthorizedUser(BOB, CEDRIC)).block();
        Assertions.assertThat((List)((List)Flux.from((Publisher)this.testee().authorizedUsers(ALICE)).collectList().block())).isEmpty();
    }

    @Test
    default public void delegatedUsersShouldReturnEmptyByDefault() {
        Assertions.assertThat((List)((List)Flux.from((Publisher)this.testee().delegatedUsers(BOB)).collectList().block())).isEmpty();
    }

    @Test
    default public void delegatedUsersShouldReturnCorrectUsers() {
        this.addUser(BOB);
        Mono.from((Publisher)this.testee().addAuthorizedUser(ALICE, BOB)).block();
        Mono.from((Publisher)this.testee().addAuthorizedUser(CEDRIC, BOB)).block();
        Assertions.assertThat((List)((List)Flux.from((Publisher)this.testee().delegatedUsers(BOB)).collectList().block())).containsOnly((Object[])new Username[]{CEDRIC, ALICE});
    }

    @Test
    default public void delegateesSourceAndDelegatorsSourceShouldBeAlignedWhenBothUsersDoNotExist() {
        Mono.from((Publisher)this.testee().addAuthorizedUser(ALICE, BOB)).block();
        Assertions.assertThat((List)((List)Flux.from((Publisher)this.testee().authorizedUsers(ALICE)).collectList().block())).containsOnly((Object[])new Username[]{BOB});
        Assertions.assertThat((List)((List)Flux.from((Publisher)this.testee().delegatedUsers(BOB)).collectList().block())).containsOnly((Object[])new Username[]{ALICE});
    }

    @Test
    default public void removeDelegateeLDAPCaseShouldSucceed() {
        Mono.from((Publisher)this.testee().addAuthorizedUser(ALICE, BOB)).block();
        Mono.from((Publisher)this.testee().removeAuthorizedUser(ALICE, BOB)).block();
        Assertions.assertThat((List)((List)Flux.from((Publisher)this.testee().authorizedUsers(ALICE)).collectList().block())).isEmpty();
        Assertions.assertThat((List)((List)Flux.from((Publisher)this.testee().delegatedUsers(BOB)).collectList().block())).isEmpty();
    }

    @Test
    default public void removeDelegatorLDAPCaseShouldSucceed() {
        Mono.from((Publisher)this.testee().addAuthorizedUser(ALICE, BOB)).block();
        Mono.from((Publisher)this.testee().removeDelegatedUser(BOB, ALICE)).block();
        Assertions.assertThat((List)((List)Flux.from((Publisher)this.testee().authorizedUsers(ALICE)).collectList().block())).isEmpty();
        Assertions.assertThat((List)((List)Flux.from((Publisher)this.testee().delegatedUsers(BOB)).collectList().block())).isEmpty();
    }

    @Test
    default public void delegatedUsersShouldReturnUpdateEntryAfterClearDelegatedBaseUser() {
        this.addUser(BOB);
        Mono.from((Publisher)this.testee().addAuthorizedUser(ALICE, BOB)).block();
        Mono.from((Publisher)this.testee().addAuthorizedUser(CEDRIC, BOB)).block();
        Mono.from((Publisher)this.testee().clear(ALICE)).block();
        Assertions.assertThat((List)((List)Flux.from((Publisher)this.testee().delegatedUsers(BOB)).collectList().block())).containsOnly((Object[])new Username[]{CEDRIC});
    }

    @Test
    default public void delegatedUsersShouldNotReturnDeletedUsers() {
        this.addUser(BOB);
        Mono.from((Publisher)this.testee().addAuthorizedUser(ALICE, BOB)).block();
        Mono.from((Publisher)this.testee().addAuthorizedUser(CEDRIC, BOB)).block();
        Mono.from((Publisher)this.testee().addAuthorizedUser(DAMIEN, BOB)).block();
        Mono.from((Publisher)this.testee().removeAuthorizedUser(ALICE, BOB)).block();
        Assertions.assertThat((List)((List)Flux.from((Publisher)this.testee().delegatedUsers(BOB)).collectList().block())).containsOnly((Object[])new Username[]{CEDRIC, DAMIEN});
    }

    @Test
    default public void delegatedUsersShouldNotReturnDuplicates() {
        this.addUser(BOB);
        Mono.from((Publisher)this.testee().addAuthorizedUser(ALICE, BOB)).block();
        Mono.from((Publisher)this.testee().addAuthorizedUser(ALICE, BOB)).block();
        Assertions.assertThat((List)((List)Flux.from((Publisher)this.testee().delegatedUsers(BOB)).collectList().block())).containsExactly((Object[])new Username[]{ALICE});
    }

    @Test
    default public void delegatedUsersShouldNotReturnUnrelatedUsers() {
        this.addUser(BOB);
        Mono.from((Publisher)this.testee().addAuthorizedUser(BOB, ALICE)).block();
        Mono.from((Publisher)this.testee().addAuthorizedUser(BOB, CEDRIC)).block();
        Assertions.assertThat((List)((List)Flux.from((Publisher)this.testee().delegatedUsers(BOB)).collectList().block())).isEmpty();
    }

    @Test
    default public void addAuthorizedUserShouldNotThrowWhenUserWithAccessDoesNotExist() {
        Assertions.assertThatCode(() -> Mono.from((Publisher)this.testee().addAuthorizedUser(BOB, ALICE)).block()).doesNotThrowAnyException();
    }

    @Test
    default public void delegatedUserShouldNotReturnDeletedUsers() {
        this.addUser(BOB);
        Mono.from((Publisher)this.testee().addAuthorizedUser(ALICE, BOB)).block();
        Mono.from((Publisher)this.testee().addAuthorizedUser(CEDRIC, BOB)).block();
        Mono.from((Publisher)this.testee().removeDelegatedUser(BOB, CEDRIC)).block();
        Assertions.assertThat((List)((List)Flux.from((Publisher)this.testee().delegatedUsers(BOB)).collectList().block())).containsOnly((Object[])new Username[]{ALICE});
    }

    @Test
    default public void removeDelegatedUserShouldBeIdempotent() {
        this.addUser(BOB);
        Mono.from((Publisher)this.testee().addAuthorizedUser(ALICE, BOB)).block();
        Mono.from((Publisher)this.testee().addAuthorizedUser(CEDRIC, BOB)).block();
        Mono.from((Publisher)this.testee().removeDelegatedUser(BOB, CEDRIC)).block();
        Mono.from((Publisher)this.testee().removeDelegatedUser(BOB, CEDRIC)).block();
        Assertions.assertThat((List)((List)Flux.from((Publisher)this.testee().delegatedUsers(BOB)).collectList().block())).containsOnly((Object[])new Username[]{ALICE});
    }

    @Test
    default public void removeDelegatedUserShouldUpdateAuthorizedUserRelated() {
        this.addUser(BOB);
        Mono.from((Publisher)this.testee().addAuthorizedUser(ALICE, BOB)).block();
        Mono.from((Publisher)this.testee().addAuthorizedUser(ALICE, CEDRIC)).block();
        Mono.from((Publisher)this.testee().removeDelegatedUser(BOB, ALICE)).block();
        Assertions.assertThat((List)((List)Flux.from((Publisher)this.testee().authorizedUsers(ALICE)).collectList().block())).containsOnly((Object[])new Username[]{CEDRIC});
    }
}

