/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.lib;

import org.apache.james.rrt.lib.SeparatorUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class SeparatorUtilTest {
    @Test
    public void getSeparatorShouldReturnCommaWhenCommaIsPresent() {
        String separator = SeparatorUtil.getSeparator((String)"regex:(.*)@localhost, regex:user@test");
        Assertions.assertThat((String)separator).isEqualTo(",");
    }

    @Test
    public void getSeparatorShouldReturnEmptyWhenColonIsPresentInPrefix() {
        String separator = SeparatorUtil.getSeparator((String)"regex:(.*)@localhost");
        Assertions.assertThat((String)separator).isEqualTo("");
    }

    @Test
    public void getSeparatorShouldReturnEmptyWhenColonIsPresent() {
        String separator = SeparatorUtil.getSeparator((String)"(.*)@localhost: user@test");
        Assertions.assertThat((String)separator).isEqualTo(":");
    }

    @Test
    public void getSeparatorShouldReturnColonWhenNoSeparator() {
        String separator = SeparatorUtil.getSeparator((String)"user@test");
        Assertions.assertThat((String)separator).isEqualTo(":");
    }
}

