/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.lib;

import java.util.Optional;
import java.util.regex.PatternSyntaxException;
import org.apache.james.core.MailAddress;
import org.apache.james.rrt.lib.UserRewritter;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class RegexRewriterTest {
    RegexRewriterTest() {
    }

    @Test
    void regexMapShouldCorrectlyReplaceMatchingUsername() throws Exception {
        MailAddress mailAddress = new MailAddress("prefix_abc@test");
        Assertions.assertThat((Optional)new UserRewritter.RegexRewriter().regexMap(mailAddress, "prefix_.*:admin@test")).contains((Object)"admin@test");
    }

    @Test
    void regexMapShouldThrowOnNullAddress() throws Exception {
        MailAddress address = null;
        Assertions.assertThatThrownBy(() -> new UserRewritter.RegexRewriter().regexMap(address, "prefix_.*:admin@test")).isInstanceOf(NullPointerException.class);
    }

    @Test
    void regexMapShouldThrowOnNullRegexMapping() throws Exception {
        String regexMapping = null;
        Assertions.assertThatThrownBy(() -> new UserRewritter.RegexRewriter().regexMap(new MailAddress("abc@test"), regexMapping)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void regexMapShouldThrowOnInvalidSyntax() throws Exception {
        Assertions.assertThatThrownBy(() -> new UserRewritter.RegexRewriter().regexMap(new MailAddress("abc@test"), "singlepart")).isInstanceOf(PatternSyntaxException.class);
    }

    @Test
    void regexMapShouldReturnInputWhenRegexDoesntMatch() throws Exception {
        Assertions.assertThat((Optional)new UserRewritter.RegexRewriter().regexMap(new MailAddress("abc@test"), "notmatching:notreplaced")).isEmpty();
    }

    @Test
    void regexMapShouldCorrectlyReplaceMatchingGroups() throws Exception {
        MailAddress mailAddress = new MailAddress("prefix_abc@test");
        Assertions.assertThat((Optional)new UserRewritter.RegexRewriter().regexMap(mailAddress, "prefix_(.*)@test:admin@${1}")).contains((Object)"admin@abc");
    }

    @Test
    void regexMapShouldCorrectlyReplaceSeveralMatchingGroups() throws Exception {
        MailAddress mailAddress = new MailAddress("prefix_abc_def@test");
        Assertions.assertThat((Optional)new UserRewritter.RegexRewriter().regexMap(mailAddress, "prefix_(.*)_(.*)@test:admin@${1}.${2}")).contains((Object)"admin@abc.def");
    }

    @Test
    void regexMapShouldCorrectlyReplaceSeveralOutOfOrderMatchingGroups() throws Exception {
        MailAddress mailAddress = new MailAddress("prefix_abc_def@test");
        Assertions.assertThat((Optional)new UserRewritter.RegexRewriter().regexMap(mailAddress, "prefix_(.*)_(.*)@test:admin@${2}.${1}")).contains((Object)"admin@def.abc");
    }

    @Test
    void regexMapShouldCorrectlyReplaceRepeatingMatchingGroups() throws Exception {
        MailAddress mailAddress = new MailAddress("prefix_abc_def@test");
        Assertions.assertThat((Optional)new UserRewritter.RegexRewriter().regexMap(mailAddress, "prefix_(.*)_(.*)@test:admin@${1}.${1}")).contains((Object)"admin@abc.abc");
    }
}

