/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.lib;

import java.util.Optional;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.rrt.lib.Mapping;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class MappingTest {
    @Test
    void hasPrefixShouldReturnTrueWhenRegex() {
        boolean hasPrefix = Mapping.Type.hasPrefix((String)(Mapping.Type.Regex.asPrefix() + "myRegex"));
        Assertions.assertThat((boolean)hasPrefix).isTrue();
    }

    @Test
    void hasPrefixShouldReturnTrueWhenDomain() {
        boolean hasPrefix = Mapping.Type.hasPrefix((String)(Mapping.Type.Domain.asPrefix() + "myDomain"));
        Assertions.assertThat((boolean)hasPrefix).isTrue();
    }

    @Test
    void hasPrefixShouldReturnTrueWhenError() {
        boolean hasPrefix = Mapping.Type.hasPrefix((String)(Mapping.Type.Error.asPrefix() + "myError"));
        Assertions.assertThat((boolean)hasPrefix).isTrue();
    }

    @Test
    void hasPrefixShouldReturnTrueWhenForward() {
        boolean hasPrefix = Mapping.Type.hasPrefix((String)(Mapping.Type.Forward.asPrefix() + "myForward"));
        Assertions.assertThat((boolean)hasPrefix).isTrue();
    }

    @Test
    void hasPrefixShouldReturnTrueWhenAlias() {
        boolean hasPrefix = Mapping.Type.hasPrefix((String)(Mapping.Type.Alias.asPrefix() + "myAlias"));
        Assertions.assertThat((boolean)hasPrefix).isTrue();
    }

    @Test
    void hasPrefixShouldReturnFalseWhenAddress() {
        boolean hasPrefix = Mapping.Type.hasPrefix((String)(Mapping.Type.Address.asPrefix() + "myAddress"));
        Assertions.assertThat((boolean)hasPrefix).isFalse();
    }

    @Test
    void detectTypeShouldReturnAddressWhenAddressPrefix() {
        Assertions.assertThat((Comparable)Mapping.detectType((String)(Mapping.Type.Address.asPrefix() + "mapping"))).isEqualTo((Object)Mapping.Type.Address);
    }

    @Test
    void detectTypeShouldReturnRegexWhenRegexPrefix() {
        Assertions.assertThat((Comparable)Mapping.detectType((String)(Mapping.Type.Regex.asPrefix() + "mapping"))).isEqualTo((Object)Mapping.Type.Regex);
    }

    @Test
    void detectTypeShouldReturnErrorWhenErrorPrefix() {
        Assertions.assertThat((Comparable)Mapping.detectType((String)(Mapping.Type.Error.asPrefix() + "mapping"))).isEqualTo((Object)Mapping.Type.Error);
    }

    @Test
    void detectTypeShouldReturnDomainWhenDomainPrefix() {
        Assertions.assertThat((Comparable)Mapping.detectType((String)(Mapping.Type.Domain.asPrefix() + "mapping"))).isEqualTo((Object)Mapping.Type.Domain);
    }

    @Test
    void detectTypeShouldReturnForwardWhenForwardPrefix() {
        Assertions.assertThat((Comparable)Mapping.detectType((String)(Mapping.Type.Forward.asPrefix() + "mapping"))).isEqualTo((Object)Mapping.Type.Forward);
    }

    @Test
    void detectTypeShouldReturnAliasWhenAliasPrefix() {
        Assertions.assertThat((Comparable)Mapping.detectType((String)(Mapping.Type.Alias.asPrefix() + "mapping"))).isEqualTo((Object)Mapping.Type.Alias);
    }

    @Test
    void withoutPrefixShouldRemoveAddressPrefix() {
        Assertions.assertThat((String)Mapping.Type.Address.withoutPrefix(Mapping.Type.Address.asPrefix() + "mapping")).isEqualTo("mapping");
    }

    @Test
    void withoutPrefixShouldDoNothingWhenAddressAndNoPrefix() {
        Assertions.assertThat((String)Mapping.Type.Address.withoutPrefix("mapping")).isEqualTo("mapping");
    }

    @Test
    void withoutPrefixShouldRemoveDomainPrefix() {
        Assertions.assertThat((String)Mapping.Type.Domain.withoutPrefix(Mapping.Type.Domain.asPrefix() + "mapping")).isEqualTo("mapping");
    }

    @Test
    void withoutPrefixShouldRemoveErrorPrefix() {
        Assertions.assertThat((String)Mapping.Type.Error.withoutPrefix(Mapping.Type.Error.asPrefix() + "mapping")).isEqualTo("mapping");
    }

    @Test
    void withoutPrefixShouldRemoveRegexPrefix() {
        Assertions.assertThat((String)Mapping.Type.Regex.withoutPrefix(Mapping.Type.Regex.asPrefix() + "mapping")).isEqualTo("mapping");
    }

    @Test
    void withoutPrefixShouldRemoveForwardPrefix() {
        Assertions.assertThat((String)Mapping.Type.Forward.withoutPrefix(Mapping.Type.Forward.asPrefix() + "mapping")).isEqualTo("mapping");
    }

    @Test
    void withoutPrefixShouldRemoveAliasPrefix() {
        Assertions.assertThat((String)Mapping.Type.Alias.withoutPrefix(Mapping.Type.Alias.asPrefix() + "mapping")).isEqualTo("mapping");
    }

    @Test
    void withoutPrefixShouldThrowOnBadPrefix() {
        Assertions.assertThatThrownBy(() -> Mapping.Type.Regex.withoutPrefix(Mapping.Type.Domain.asPrefix() + "mapping")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void withoutPrefixShouldThrowWhenNoPrefix() {
        Assertions.assertThatThrownBy(() -> Mapping.Type.Regex.withoutPrefix("mapping")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void withoutPrefixShouldThrowWhenNoPrefixOnForwardType() {
        Assertions.assertThatThrownBy(() -> Mapping.Type.Forward.withoutPrefix("mapping")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void beanShouldRespectBeanContract() {
        EqualsVerifier.forClass(Mapping.Impl.class).withOnlyTheseFields(new String[]{"type", "mapping"}).verify();
    }

    @Test
    void addressFactoryMethodShouldThrowOnNull() {
        Assertions.assertThatThrownBy(() -> Mapping.address(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void regexFactoryMethodShouldThrowOnNull() {
        Assertions.assertThatThrownBy(() -> Mapping.regex(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void domainFactoryMethodShouldThrowOnNull() {
        Assertions.assertThatThrownBy(() -> Mapping.domain(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void domainAliasFactoryMethodShouldThrowOnNull() {
        Assertions.assertThatThrownBy(() -> Mapping.domainAlias(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void errorFactoryMethodShouldThrowOnNull() {
        Assertions.assertThatThrownBy(() -> Mapping.error(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void forwardFactoryMethodShouldThrowOnNull() {
        Assertions.assertThatThrownBy(() -> Mapping.forward(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void groupFactoryMethodShouldThrowOnNull() {
        Assertions.assertThatThrownBy(() -> Mapping.group(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void aliasFactoryMethodShouldThrowOnNull() {
        Assertions.assertThatThrownBy(() -> Mapping.alias(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void hasDomainShouldReturnTrueWhenMappingContainAtMark() {
        Assertions.assertThat((boolean)Mapping.address((String)"a@b").hasDomain()).isTrue();
    }

    @Test
    void hasDomainShouldReturnFalseWhenMappingIsEmpty() {
        Assertions.assertThat((boolean)Mapping.address((String)"").hasDomain()).isFalse();
    }

    @Test
    void hasDomainShouldReturnFalseWhenMappingIsBlank() {
        Assertions.assertThat((boolean)Mapping.address((String)" ").hasDomain()).isFalse();
    }

    @Test
    void hasDomainShouldReturnFalseWhenMappingDoesntContainAtMark() {
        Assertions.assertThat((boolean)Mapping.address((String)"abc").hasDomain()).isFalse();
    }

    @Test
    void appendDefaultDomainShouldWorkOnValidDomain() {
        Assertions.assertThat((Object)Mapping.address((String)"abc").appendDomainIfNone(() -> Domain.of((String)"domain"))).isEqualTo((Object)Mapping.address((String)"abc@domain"));
    }

    @Test
    void appendDefaultDomainShouldNotAddDomainWhenMappingAlreadyContainsDomains() {
        Assertions.assertThat((Object)Mapping.address((String)"abc@d").appendDomainIfNone(() -> Domain.of((String)"domain"))).isEqualTo((Object)Mapping.address((String)"abc@d"));
    }

    @Test
    void appendDomainShouldThrowWhenNullDomain() {
        Assertions.assertThatThrownBy(() -> Mapping.address((String)"abc@d").appendDomainIfNone(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void getTypeShouldReturnAddressWhenNoPrefix() {
        Assertions.assertThat((Comparable)Mapping.address((String)"abc").getType()).isEqualTo((Object)Mapping.Type.Address);
    }

    @Test
    void getTypeShouldReturnAddressWhenEmpty() {
        Assertions.assertThat((Comparable)Mapping.address((String)"").getType()).isEqualTo((Object)Mapping.Type.Address);
    }

    @Test
    void getTypeShouldReturnRegexWhenRegexPrefix() {
        Assertions.assertThat((Comparable)Mapping.regex((String)"abc").getType()).isEqualTo((Object)Mapping.Type.Regex);
    }

    @Test
    void getTypeShouldReturnErrorWhenErrorPrefix() {
        Assertions.assertThat((Comparable)Mapping.error((String)"abc").getType()).isEqualTo((Object)Mapping.Type.Error);
    }

    @Test
    void getTypeShouldReturnDomainWhenDomainPrefix() {
        Assertions.assertThat((Comparable)Mapping.domain((Domain)Domain.of((String)"abc")).getType()).isEqualTo((Object)Mapping.Type.Domain);
    }

    @Test
    void getTypeShouldReturnDomainAliasWhenDomainAliasPrefix() {
        Assertions.assertThat((Comparable)Mapping.domainAlias((Domain)Domain.of((String)"abc")).getType()).isEqualTo((Object)Mapping.Type.DomainAlias);
    }

    @Test
    void getTypeShouldReturnForwardWhenForwardPrefix() {
        Assertions.assertThat((Comparable)Mapping.forward((String)"abc").getType()).isEqualTo((Object)Mapping.Type.Forward);
    }

    @Test
    void getTypeShouldReturnGroupWhenGroupPrefix() {
        Assertions.assertThat((Comparable)Mapping.group((String)"abc").getType()).isEqualTo((Object)Mapping.Type.Group);
    }

    @Test
    void getTypeShouldReturnAliasWhenAliasPrefix() {
        Assertions.assertThat((Comparable)Mapping.alias((String)"abc").getType()).isEqualTo((Object)Mapping.Type.Alias);
    }

    @Test
    void getErrorMessageShouldThrowWhenMappingIsNotAnError() {
        Assertions.assertThatThrownBy(() -> Mapping.domain((Domain)Domain.of((String)"toto")).getErrorMessage()).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void getErrorMessageShouldReturnMessageWhenErrorWithMessage() {
        Assertions.assertThat((String)Mapping.error((String)"toto").getErrorMessage()).isEqualTo("toto");
    }

    @Test
    void getErrorMessageShouldReturnWhenErrorWithoutMessage() {
        Assertions.assertThat((String)Mapping.error((String)"").getErrorMessage()).isEqualTo("");
    }

    @Test
    void asMailAddressShouldReturnMappingValueForAddress() throws Exception {
        Assertions.assertThat((Optional)Mapping.address((String)"value@domain").asMailAddress()).contains((Object)new MailAddress("value@domain"));
    }

    @Test
    void asMailAddressShouldReturnEmptyOnInvalidAddress() {
        Assertions.assertThat((Optional)Mapping.address((String)"value").asMailAddress()).isEmpty();
    }

    @Test
    void asMailAddressShouldReturnEmptyForError() {
        Assertions.assertThat((Optional)Mapping.error((String)"value").asMailAddress()).isEmpty();
    }

    @Test
    void asMailAddressShouldReturnEmptyForRegex() {
        Assertions.assertThat((Optional)Mapping.regex((String)"value").asMailAddress()).isEmpty();
    }

    @Test
    void asMailAddressShouldReturnEmptyForDomain() {
        Assertions.assertThat((Optional)Mapping.domain((Domain)Domain.of((String)"value")).asMailAddress()).isEmpty();
    }

    @Test
    void asMailAddressShouldReturnEmptyForDomainAlias() {
        Assertions.assertThat((Optional)Mapping.domainAlias((Domain)Domain.of((String)"value")).asMailAddress()).isEmpty();
    }

    @Test
    void asMailAddressShouldReturnMappingValueForForward() throws Exception {
        Assertions.assertThat((Optional)Mapping.forward((String)"value@domain").asMailAddress()).contains((Object)new MailAddress("value@domain"));
    }

    @Test
    void asMailAddressShouldReturnMappingValueForAlias() throws Exception {
        Assertions.assertThat((Optional)Mapping.alias((String)"value@domain").asMailAddress()).contains((Object)new MailAddress("value@domain"));
    }
}

