/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.lib;

import java.util.Optional;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.rrt.lib.MappingSource;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MappingSourceTest {
    private static final String DOMAIN_AS_STRING = "domain.tld";
    private static final Domain DOMAIN = Domain.of((String)"domain.tld");
    private static final String USER = "alice";
    private static final String MAIL_ADDRESS = "alice@domain.tld";

    MappingSourceTest() {
    }

    @Test
    void shouldRespectBeanContract() {
        EqualsVerifier.forClass(MappingSource.class).verify();
    }

    @Test
    void asMailAddressStringShouldSerializeWilcard() {
        MappingSource mappingSource = MappingSource.wildCard();
        Assertions.assertThat((String)mappingSource.asMailAddressString()).isEqualTo("*@*");
    }

    @Test
    void asMailAddressStringShouldSerializeDomain() {
        MappingSource mappingSource = MappingSource.fromDomain((Domain)DOMAIN);
        Assertions.assertThat((String)mappingSource.asMailAddressString()).isEqualTo("*@domain.tld");
    }

    @Test
    void asMailAddressStringShouldSerializeUser() {
        MappingSource mappingSource = MappingSource.fromUser((String)USER, (String)DOMAIN_AS_STRING);
        Assertions.assertThat((String)mappingSource.asMailAddressString()).isEqualTo(MAIL_ADDRESS);
    }

    @Test
    void asMailAddressStringShouldSerializeUserWithoutDomain() {
        MappingSource mappingSource = MappingSource.fromUser((Username)Username.of((String)USER));
        Assertions.assertThat((String)mappingSource.asMailAddressString()).isEqualTo("alice@*");
    }

    @Test
    void asMailAddressStringShouldSerializeMailAddress() throws Exception {
        MappingSource mappingSource = MappingSource.fromMailAddress((MailAddress)new MailAddress(MAIL_ADDRESS));
        Assertions.assertThat((String)mappingSource.asMailAddressString()).isEqualTo(MAIL_ADDRESS);
    }

    @Test
    void availableDomainShouldReturnUserDomainIfExist() throws Exception {
        MappingSource mappingSource = MappingSource.fromMailAddress((MailAddress)new MailAddress(MAIL_ADDRESS));
        Assertions.assertThat((Optional)mappingSource.availableDomain()).contains((Object)DOMAIN);
    }

    @Test
    void availableDomainShouldReturnDomainIfExist() {
        MappingSource mappingSource = MappingSource.fromDomain((Domain)DOMAIN);
        Assertions.assertThat((Optional)mappingSource.availableDomain()).contains((Object)DOMAIN);
    }

    @Test
    void availableDomainShouldReturnEmptyWhenNoDomainUserOrDomain() {
        MappingSource mappingSource = MappingSource.wildCard();
        Assertions.assertThat((Optional)mappingSource.availableDomain()).isEmpty();
    }
}

