/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.lib;

import com.github.fge.lambdas.Throwing;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.rrt.api.CanSendFrom;
import org.apache.james.rrt.lib.Mapping;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public interface CanSendFromContract {
    public static final Domain DOMAIN = Domain.of((String)"example.com");
    public static final Domain OTHER_DOMAIN = Domain.of((String)"other.org");
    public static final Username USER = Username.of((String)"user@example.com");
    public static final Username USER_ALIAS = Username.of((String)"alias@example.com");
    public static final Username OTHER_USER = Username.of((String)"other@example.com");

    public CanSendFrom canSendFrom();

    public void addAliasMapping(Username var1, Username var2) throws Exception;

    public void addDomainMapping(Domain var1, Domain var2, Mapping.Type var3) throws Exception;

    public void addGroupMapping(String var1, Username var2) throws Exception;

    default public RequireUserName redirectUser(Username alias) {
        return user -> this.addAliasMapping(alias, user);
    }

    default public RequireDomain redirectDomain(Domain alias) {
        return domain -> type -> this.addDomainMapping(alias, domain, type);
    }

    default public RequireUserName redirectGroup(String group) {
        return user -> this.addGroupMapping(group, user);
    }

    @Test
    default public void userCanSendFromShouldBeFalseWhenSenderIsNotTheUser() {
        Assertions.assertThat((boolean)this.canSendFrom().userCanSendFrom(USER, OTHER_USER)).isFalse();
    }

    @Test
    default public void userCanSendFromShouldBeTrueWhenSenderIsTheUser() {
        Assertions.assertThat((boolean)this.canSendFrom().userCanSendFrom(USER, USER)).isTrue();
    }

    @Test
    default public void userCanSendFromShouldBeFalseWhenSenderIsAnAliasOfAnotherUser() throws Exception {
        this.redirectUser(USER_ALIAS).to(OTHER_USER);
        Assertions.assertThat((boolean)this.canSendFrom().userCanSendFrom(USER, USER_ALIAS)).isFalse();
    }

    @Test
    default public void userCanSendFromShouldBeTrueWhenSenderIsAnAliasOfTheUser() throws Exception {
        this.redirectUser(USER_ALIAS).to(USER);
        Assertions.assertThat((boolean)this.canSendFrom().userCanSendFrom(USER, USER_ALIAS)).isTrue();
    }

    @Test
    default public void userCanSendFromShouldBeTrueWhenSenderIsAnAliasOfAnAliasOfTheUser() throws Exception {
        Username userAliasBis = Username.of((String)("aliasbis@" + DOMAIN.asString()));
        this.redirectUser(userAliasBis).to(USER_ALIAS);
        this.redirectUser(USER_ALIAS).to(USER);
        Assertions.assertThat((boolean)this.canSendFrom().userCanSendFrom(USER, userAliasBis)).isTrue();
    }

    @Test
    default public void userCanSendFromShouldBeFalseWhenSenderIsAnAliasOfAnAliasOfAnAliasOfTheUser() throws Exception {
        Username userAliasBis = Username.of((String)("aliasbis@" + DOMAIN.asString()));
        Username userAliasTer = Username.of((String)("aliaster@" + DOMAIN.asString()));
        this.redirectUser(userAliasTer).to(userAliasBis);
        this.redirectUser(userAliasBis).to(USER_ALIAS);
        this.redirectUser(USER_ALIAS).to(USER);
        Assertions.assertThat((boolean)this.canSendFrom().userCanSendFrom(USER, userAliasTer)).isTrue();
    }

    @Test
    default public void userCanSendFromShouldBeTrueWhenSenderIsAnAliasOfAnAliasInAnotherDomainOfTheUser() throws Exception {
        Username userAlias = Username.of((String)("aliasbis@" + OTHER_DOMAIN.asString()));
        Username userAliasBis = Username.of((String)("aliaster@" + OTHER_DOMAIN.asString()));
        this.redirectUser(userAliasBis).to(userAlias);
        this.redirectUser(userAlias).to(USER);
        Assertions.assertThat((boolean)this.canSendFrom().userCanSendFrom(USER, userAliasBis)).isTrue();
    }

    @Test
    default public void userCanSendFromShouldBeTrueWhenSenderIsAnAliasInAnotherDomainOfAnAliasOfTheUser() throws Exception {
        Username userAliasBis = Username.of((String)("aliasbis@" + OTHER_DOMAIN.asString()));
        this.redirectUser(userAliasBis).to(USER_ALIAS);
        this.redirectUser(USER_ALIAS).to(USER);
        Assertions.assertThat((boolean)this.canSendFrom().userCanSendFrom(USER, userAliasBis)).isTrue();
    }

    @Test
    default public void userCanSendFromShouldBeTrueWhenSenderIsAnAliasOfTheDomainUser() throws Exception {
        Username fromUser = USER.withOtherDomain(OTHER_DOMAIN);
        this.redirectDomain(OTHER_DOMAIN).to(DOMAIN).asAlias();
        Assertions.assertThat((boolean)this.canSendFrom().userCanSendFrom(USER, fromUser)).isTrue();
    }

    @Test
    default public void userCanSendFromShouldBeFalseWhenDomainMapping() throws Exception {
        Username fromUser = USER.withOtherDomain(OTHER_DOMAIN);
        this.redirectDomain(OTHER_DOMAIN).to(DOMAIN).asMapping();
        Assertions.assertThat((boolean)this.canSendFrom().userCanSendFrom(USER, fromUser)).isFalse();
    }

    @Test
    default public void userCanSendFromShouldBeFalseWhenWhenSenderIsAnAliasOfTheUserFromAGroupAlias() throws Exception {
        Username fromGroup = Username.of((String)"group@example.com");
        this.redirectGroup("group@example.com").to(USER);
        Assertions.assertThat((boolean)this.canSendFrom().userCanSendFrom(USER, fromGroup)).isFalse();
    }

    @Test
    default public void allValidFromAddressesShouldContainOnlyUserAddressWhenUserHasNoAlias() throws Exception {
        Assertions.assertThat((Stream)this.canSendFrom().allValidFromAddressesForUser(USER)).containsExactly((Object[])new MailAddress[]{USER.asMailAddress()});
    }

    @Test
    default public void allValidFromAddressesShouldContainOnlyUserAddressWhenUserHasNoAliasAndAnotherUserHasOne() throws Exception {
        this.redirectUser(USER_ALIAS).to(OTHER_USER);
        Assertions.assertThat((Stream)this.canSendFrom().allValidFromAddressesForUser(USER)).containsExactly((Object[])new MailAddress[]{USER.asMailAddress()});
    }

    @Test
    default public void allValidFromAddressesShouldContainUserAddressAndAnAliasOfTheUser() throws Exception {
        this.redirectUser(USER_ALIAS).to(USER);
        Assertions.assertThat((Stream)this.canSendFrom().allValidFromAddressesForUser(USER)).containsExactlyInAnyOrder((Object[])new MailAddress[]{USER.asMailAddress(), USER_ALIAS.asMailAddress()});
    }

    @Test
    default public void allValidFromAddressesFromShouldBeTrueWhenSenderIsAnAliasOfAnAliasOfTheUser() throws Exception {
        Username userAliasBis = Username.of((String)("aliasbis@" + DOMAIN.asString()));
        this.redirectUser(userAliasBis).to(USER_ALIAS);
        this.redirectUser(USER_ALIAS).to(USER);
        Assertions.assertThat((Stream)this.canSendFrom().allValidFromAddressesForUser(USER)).containsExactlyInAnyOrder((Object[])new MailAddress[]{USER.asMailAddress(), USER_ALIAS.asMailAddress(), userAliasBis.asMailAddress()});
    }

    @Test
    default public void allValidFromAddressesShouldContainUserAddressAndAnAliasOfTheDomainUser() throws Exception {
        Username fromUser = USER.withOtherDomain(OTHER_DOMAIN);
        this.redirectDomain(OTHER_DOMAIN).to(DOMAIN).asAlias();
        Assertions.assertThat((Stream)this.canSendFrom().allValidFromAddressesForUser(USER)).containsExactlyInAnyOrder((Object[])new MailAddress[]{USER.asMailAddress(), fromUser.asMailAddress()});
    }

    @Test
    default public void allValidFromAddressesShouldContainUserAddressAndAnAliasOfTheDomainUserFromAnotherDomain() throws Exception {
        Username userAliasOtherDomain = USER_ALIAS.withOtherDomain(OTHER_DOMAIN);
        this.redirectDomain(OTHER_DOMAIN).to(DOMAIN).asAlias();
        this.redirectUser(userAliasOtherDomain).to(USER);
        Username userAliasMainDomain = USER_ALIAS.withOtherDomain(DOMAIN);
        Username userOtherDomain = USER.withOtherDomain(OTHER_DOMAIN);
        Assertions.assertThat((Stream)this.canSendFrom().allValidFromAddressesForUser(USER)).containsExactlyInAnyOrder((Object[])new MailAddress[]{USER.asMailAddress(), userAliasOtherDomain.asMailAddress(), userAliasMainDomain.asMailAddress(), userOtherDomain.asMailAddress()});
    }

    @Test
    default public void allValidFromAddressesShouldContainASenderAliasOfAnAliasOfTheUser() throws Exception {
        Username userAliasBis = Username.of((String)("aliasbis@" + DOMAIN.asString()));
        this.redirectUser(userAliasBis).to(USER_ALIAS);
        this.redirectUser(USER_ALIAS).to(USER);
        Assertions.assertThat((boolean)this.canSendFrom().userCanSendFrom(USER, userAliasBis)).isTrue();
    }

    @Test
    default public void allValidFromAddressesShouldNotContainAliasesRequiringMoreThanTenRecursionSteps() throws Exception {
        int recursionLevel = 10;
        IntStream.range(0, recursionLevel).forEach(Throwing.intConsumer(aliasNumber -> {
            Username userAliasFrom = Username.of((String)("alias" + aliasNumber + "@" + DOMAIN.asString()));
            Username userAliasTo = aliasNumber == 0 ? USER_ALIAS : Username.of((String)("alias" + (aliasNumber - 1) + "@" + DOMAIN.asString()));
            this.redirectUser(userAliasFrom).to(userAliasTo);
        }).sneakyThrow());
        Username userAliasExcluded = Username.of((String)("alias" + (recursionLevel - 1) + "@" + DOMAIN.asString()));
        this.redirectUser(USER_ALIAS).to(USER);
        Assertions.assertThat((Stream)this.canSendFrom().allValidFromAddressesForUser(USER)).doesNotContain((Object[])new MailAddress[]{userAliasExcluded.asMailAddress()});
    }

    @Test
    default public void allValidFromAddressesShouldContainASenderAliasOfAnAliasInAnotherDomainOfTheUser() throws Exception {
        Username userAlias = Username.of((String)("aliasbis@" + OTHER_DOMAIN.asString()));
        Username userAliasBis = Username.of((String)("aliaster@" + OTHER_DOMAIN.asString()));
        this.redirectUser(userAliasBis).to(userAlias);
        this.redirectUser(userAlias).to(USER);
        Assertions.assertThat((Stream)this.canSendFrom().allValidFromAddressesForUser(USER)).contains((Object[])new MailAddress[]{userAliasBis.asMailAddress()});
    }

    @Test
    default public void allValidFromAddressesShouldContainAUserAliasFollowingADomainAliasResolution() throws Exception {
        Username userAliasBis = Username.of((String)("aliasbis@" + OTHER_DOMAIN.asString()));
        this.redirectUser(userAliasBis).to(USER_ALIAS);
        this.redirectUser(USER_ALIAS).to(USER);
        Assertions.assertThat((Stream)this.canSendFrom().allValidFromAddressesForUser(USER)).contains((Object[])new MailAddress[]{userAliasBis.asMailAddress()});
    }

    @FunctionalInterface
    public static interface RequireUserName {
        public void to(Username var1) throws Exception;
    }

    @FunctionalInterface
    public static interface RequireDomain {
        public RequireType to(Domain var1) throws Exception;
    }

    @FunctionalInterface
    public static interface RequireType {
        public void withType(Mapping.Type var1) throws Exception;

        default public void asAlias() throws Exception {
            this.withType(Mapping.Type.DomainAlias);
        }

        default public void asMapping() throws Exception {
            this.withType(Mapping.Type.Domain);
        }
    }
}

