/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.lib;

import com.github.fge.lambdas.Throwing;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.rrt.api.AliasReverseResolver;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public interface AliasReverseResolverContract {
    public static final Domain DOMAIN = Domain.of((String)"example.com");
    public static final Domain OTHER_DOMAIN = Domain.of((String)"other.org");
    public static final Username USER = Username.of((String)"user@example.com");
    public static final Username USER_ALIAS = Username.of((String)"alias@example.com");
    public static final Username OTHER_USER = Username.of((String)"other@example.com");

    public AliasReverseResolver aliasReverseResolver();

    public void addAliasMapping(Username var1, Username var2) throws Exception;

    public void addDomainAlias(Domain var1, Domain var2) throws Exception;

    public void addGroupMapping(String var1, Username var2) throws Exception;

    default public RequireUserName redirectUser(Username alias) {
        return user -> this.addAliasMapping(alias, user);
    }

    default public RequireDomain redirectDomain(Domain alias) {
        return domain -> this.addDomainAlias(alias, domain);
    }

    @Test
    default public void listAddressesShouldContainOnlyUserAddressWhenUserHasNoAlias() throws Exception {
        Assertions.assertThat((Stream)this.aliasReverseResolver().listAddresses(USER)).containsExactly((Object[])new MailAddress[]{USER.asMailAddress()});
    }

    @Test
    default public void listAddressesShouldContainOnlyUserAddressWhenUserHasNoAliasAndAnotherUserHasOne() throws Exception {
        this.redirectUser(USER_ALIAS).to(OTHER_USER);
        Assertions.assertThat((Stream)this.aliasReverseResolver().listAddresses(USER)).containsExactly((Object[])new MailAddress[]{USER.asMailAddress()});
    }

    @Test
    default public void listAddressesShouldContainUserAddressAndAnAliasOfTheUser() throws Exception {
        this.redirectUser(USER_ALIAS).to(USER);
        Assertions.assertThat((Stream)this.aliasReverseResolver().listAddresses(USER)).containsExactlyInAnyOrder((Object[])new MailAddress[]{USER.asMailAddress(), USER_ALIAS.asMailAddress()});
    }

    @Test
    default public void listAddressesShouldBeTrueWhenSenderIsAnAliasOfAnAliasOfTheUser() throws Exception {
        Username userAliasBis = Username.of((String)("aliasbis@" + DOMAIN.asString()));
        this.redirectUser(userAliasBis).to(USER_ALIAS);
        this.redirectUser(USER_ALIAS).to(USER);
        Assertions.assertThat((Stream)this.aliasReverseResolver().listAddresses(USER)).containsExactlyInAnyOrder((Object[])new MailAddress[]{USER.asMailAddress(), USER_ALIAS.asMailAddress(), userAliasBis.asMailAddress()});
    }

    @Test
    default public void listAddressesShouldContainUserAddressAndAnAliasOfTheDomainUser() throws Exception {
        Username fromUser = USER.withOtherDomain(OTHER_DOMAIN);
        this.redirectDomain(OTHER_DOMAIN).to(DOMAIN);
        Assertions.assertThat((Stream)this.aliasReverseResolver().listAddresses(USER)).containsExactlyInAnyOrder((Object[])new MailAddress[]{USER.asMailAddress(), fromUser.asMailAddress()});
    }

    @Test
    default public void listAddressesShouldContainUserAddressAndAnAliasOfTheDomainUserFromAnotherDomain() throws Exception {
        Username userAliasOtherDomain = USER_ALIAS.withOtherDomain(OTHER_DOMAIN);
        this.redirectDomain(OTHER_DOMAIN).to(DOMAIN);
        this.redirectUser(userAliasOtherDomain).to(USER);
        Username userAliasMainDomain = USER_ALIAS.withOtherDomain(DOMAIN);
        Username userOtherDomain = USER.withOtherDomain(OTHER_DOMAIN);
        Assertions.assertThat((Stream)this.aliasReverseResolver().listAddresses(USER)).containsExactlyInAnyOrder((Object[])new MailAddress[]{USER.asMailAddress(), userAliasOtherDomain.asMailAddress(), userAliasMainDomain.asMailAddress(), userOtherDomain.asMailAddress()});
    }

    @Test
    default public void listAddressesShouldNotContainAliasesRequiringMoreThanTenRecursionSteps() throws Exception {
        int recursionLevel = 10;
        IntStream.range(0, recursionLevel).forEach(Throwing.intConsumer(aliasNumber -> {
            Username userAliasFrom = Username.of((String)("alias" + aliasNumber + "@" + DOMAIN.asString()));
            Username userAliasTo = aliasNumber == 0 ? USER_ALIAS : Username.of((String)("alias" + (aliasNumber - 1) + "@" + DOMAIN.asString()));
            this.redirectUser(userAliasFrom).to(userAliasTo);
        }).sneakyThrow());
        Username userAliasExcluded = Username.of((String)("alias" + (recursionLevel - 1) + "@" + DOMAIN.asString()));
        this.redirectUser(USER_ALIAS).to(USER);
        Assertions.assertThat((Stream)this.aliasReverseResolver().listAddresses(USER)).doesNotContain((Object[])new MailAddress[]{userAliasExcluded.asMailAddress()});
    }

    @Test
    default public void listAddressesShouldContainASenderAliasOfAnAliasInAnotherDomainOfTheUser() throws Exception {
        Username userAlias = Username.of((String)("aliasbis@" + OTHER_DOMAIN.asString()));
        Username userAliasBis = Username.of((String)("aliaster@" + OTHER_DOMAIN.asString()));
        this.redirectUser(userAliasBis).to(userAlias);
        this.redirectUser(userAlias).to(USER);
        Assertions.assertThat((Stream)this.aliasReverseResolver().listAddresses(USER)).contains((Object[])new MailAddress[]{userAliasBis.asMailAddress()});
    }

    @Test
    default public void listAddressesShouldContainAUserAliasFollowingADomainAliasResolution() throws Exception {
        Username userAliasBis = Username.of((String)("aliasbis@" + OTHER_DOMAIN.asString()));
        this.redirectUser(userAliasBis).to(USER_ALIAS);
        this.redirectUser(USER_ALIAS).to(USER);
        Assertions.assertThat((Stream)this.aliasReverseResolver().listAddresses(USER)).contains((Object[])new MailAddress[]{userAliasBis.asMailAddress()});
    }

    @FunctionalInterface
    public static interface RequireUserName {
        public void to(Username var1) throws Exception;
    }

    @FunctionalInterface
    public static interface RequireDomain {
        public void to(Domain var1) throws Exception;
    }
}

