/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.api;

import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.rrt.api.RecipientRewriteTableConfiguration;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class RecipientRewriteTableConfigurationTest {
    RecipientRewriteTableConfigurationTest() {
    }

    @Test
    void shouldRespectBeanContract() {
        EqualsVerifier.forClass(RecipientRewriteTableConfiguration.class).verify();
    }

    @Test
    void emptyConfigurationShouldHaveDefaults() throws ConfigurationException {
        BaseHierarchicalConfiguration configuration = new BaseHierarchicalConfiguration();
        RecipientRewriteTableConfiguration recipientRewriteTableConfiguration = RecipientRewriteTableConfiguration.fromConfiguration((HierarchicalConfiguration)configuration);
        Assertions.assertThat((int)recipientRewriteTableConfiguration.getMappingLimit()).isEqualTo(10);
        Assertions.assertThat((boolean)recipientRewriteTableConfiguration.isRecursive()).isTrue();
    }

    @Test
    void negativeLimitShouldThrows() {
        BaseHierarchicalConfiguration configuration = new BaseHierarchicalConfiguration();
        configuration.addProperty("recursiveMapping", (Object)"true");
        configuration.addProperty("mappingLimit", (Object)-1);
        Assertions.assertThatCode(() -> RecipientRewriteTableConfiguration.fromConfiguration((HierarchicalConfiguration)configuration)).isInstanceOf(ConfigurationException.class);
    }

    @Test
    void goodConfigurationShouldPopulateTheConfiguration() throws ConfigurationException {
        BaseHierarchicalConfiguration configuration = new BaseHierarchicalConfiguration();
        configuration.addProperty("recursiveMapping", (Object)"true");
        configuration.addProperty("mappingLimit", (Object)42);
        RecipientRewriteTableConfiguration recipientRewriteTableConfiguration = RecipientRewriteTableConfiguration.fromConfiguration((HierarchicalConfiguration)configuration);
        Assertions.assertThat((int)recipientRewriteTableConfiguration.getMappingLimit()).isEqualTo(42);
        Assertions.assertThat((boolean)recipientRewriteTableConfiguration.isRecursive()).isTrue();
    }

    @Test
    void goodConfigurationWithoutMappingShouldHaveANullMappingLevel() throws ConfigurationException {
        BaseHierarchicalConfiguration configuration = new BaseHierarchicalConfiguration();
        configuration.addProperty("recursiveMapping", (Object)"false");
        configuration.addProperty("mappingLimit", (Object)42);
        RecipientRewriteTableConfiguration recipientRewriteTableConfiguration = RecipientRewriteTableConfiguration.fromConfiguration((HierarchicalConfiguration)configuration);
        Assertions.assertThat((int)recipientRewriteTableConfiguration.getMappingLimit()).isEqualTo(0);
        Assertions.assertThat((boolean)recipientRewriteTableConfiguration.isRecursive()).isFalse();
    }
}

