/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.dlp.api;

import com.google.common.collect.ImmutableList;
import org.apache.james.core.Domain;
import org.apache.james.dlp.api.DLPConfigurationItem;
import org.apache.james.dlp.api.DLPConfigurationStore;
import org.apache.james.dlp.api.DLPFixture;
import org.apache.james.dlp.api.DLPRules;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public interface DLPConfigurationStoreContract {
    public static final Domain OTHER_DOMAIN = Domain.of((String)"any.com");

    @Test
    default public void listShouldReturnEmptyWhenNone(DLPConfigurationStore dlpConfigurationStore) {
        Assertions.assertThat((Iterable)((Iterable)Mono.from((Publisher)dlpConfigurationStore.list(Domain.LOCALHOST)).block())).isEmpty();
    }

    @Test
    default public void listShouldReturnExistingEntries(DLPConfigurationStore dlpConfigurationStore) {
        dlpConfigurationStore.store(Domain.LOCALHOST, DLPFixture.RULE, new DLPConfigurationItem[]{DLPFixture.RULE_2});
        Assertions.assertThat((Iterable)((Iterable)Mono.from((Publisher)dlpConfigurationStore.list(Domain.LOCALHOST)).block())).containsOnly((Object[])new DLPConfigurationItem[]{DLPFixture.RULE, DLPFixture.RULE_2});
    }

    @Test
    default public void listShouldNotReturnEntriesOfOtherDomains(DLPConfigurationStore dlpConfigurationStore) {
        dlpConfigurationStore.store(Domain.LOCALHOST, DLPFixture.RULE, new DLPConfigurationItem[0]);
        dlpConfigurationStore.store(OTHER_DOMAIN, DLPFixture.RULE_2, new DLPConfigurationItem[0]);
        Assertions.assertThat((Iterable)((Iterable)Mono.from((Publisher)dlpConfigurationStore.list(Domain.LOCALHOST)).block())).containsOnly((Object[])new DLPConfigurationItem[]{DLPFixture.RULE});
    }

    @Test
    default public void clearShouldRemoveAllEnriesOfADomain(DLPConfigurationStore dlpConfigurationStore) {
        dlpConfigurationStore.store(Domain.LOCALHOST, DLPFixture.RULE, new DLPConfigurationItem[]{DLPFixture.RULE_2});
        dlpConfigurationStore.clear(Domain.LOCALHOST);
        Assertions.assertThat((Iterable)((Iterable)Mono.from((Publisher)dlpConfigurationStore.list(Domain.LOCALHOST)).block())).isEmpty();
    }

    @Test
    default public void clearShouldNotFailWhenDomainDoesNotExist(DLPConfigurationStore dlpConfigurationStore) {
        Assertions.assertThatCode(() -> dlpConfigurationStore.clear(Domain.LOCALHOST)).doesNotThrowAnyException();
    }

    @Test
    default public void clearShouldOnlyRemoveEntriesOfADomain(DLPConfigurationStore dlpConfigurationStore) {
        dlpConfigurationStore.store(Domain.LOCALHOST, DLPFixture.RULE, new DLPConfigurationItem[0]);
        dlpConfigurationStore.store(OTHER_DOMAIN, DLPFixture.RULE_2, new DLPConfigurationItem[0]);
        dlpConfigurationStore.clear(Domain.LOCALHOST);
        Assertions.assertThat((Iterable)((Iterable)Mono.from((Publisher)dlpConfigurationStore.list(OTHER_DOMAIN)).block())).containsOnly((Object[])new DLPConfigurationItem[]{DLPFixture.RULE_2});
    }

    @Test
    default public void clearShouldOnlyRemovePreviouslyExistingEntries(DLPConfigurationStore dlpConfigurationStore) {
        dlpConfigurationStore.store(Domain.LOCALHOST, DLPFixture.RULE, new DLPConfigurationItem[]{DLPFixture.RULE_2});
        dlpConfigurationStore.clear(Domain.LOCALHOST);
        dlpConfigurationStore.store(Domain.LOCALHOST, DLPFixture.RULE, new DLPConfigurationItem[0]);
        Assertions.assertThat((Iterable)((Iterable)Mono.from((Publisher)dlpConfigurationStore.list(Domain.LOCALHOST)).block())).containsOnly((Object[])new DLPConfigurationItem[]{DLPFixture.RULE});
    }

    @Test
    default public void storeShouldOverwritePreviouslyStoredEntries(DLPConfigurationStore dlpConfigurationStore) {
        dlpConfigurationStore.store(Domain.LOCALHOST, DLPFixture.RULE, new DLPConfigurationItem[]{DLPFixture.RULE_2});
        dlpConfigurationStore.store(Domain.LOCALHOST, DLPFixture.RULE, new DLPConfigurationItem[0]);
        Assertions.assertThat((Iterable)((Iterable)Mono.from((Publisher)dlpConfigurationStore.list(Domain.LOCALHOST)).block())).containsOnly((Object[])new DLPConfigurationItem[]{DLPFixture.RULE});
    }

    @Test
    default public void storeShouldBeAbleToAddRules(DLPConfigurationStore dlpConfigurationStore) {
        dlpConfigurationStore.store(Domain.LOCALHOST, DLPFixture.RULE, new DLPConfigurationItem[0]);
        dlpConfigurationStore.store(Domain.LOCALHOST, DLPFixture.RULE, new DLPConfigurationItem[]{DLPFixture.RULE_2});
        Assertions.assertThat((Iterable)((Iterable)Mono.from((Publisher)dlpConfigurationStore.list(Domain.LOCALHOST)).block())).containsOnly((Object[])new DLPConfigurationItem[]{DLPFixture.RULE, DLPFixture.RULE_2});
    }

    @Test
    default public void storeShouldRejectDuplicateIds(DLPConfigurationStore dlpConfigurationStore) {
        Assertions.assertThatThrownBy(() -> dlpConfigurationStore.store(Domain.LOCALHOST, DLPFixture.RULE, new DLPConfigurationItem[]{DLPFixture.RULE})).isInstanceOf(DLPRules.DuplicateRulesIdsException.class);
    }

    @Test
    default public void storeShouldUpdate(DLPConfigurationStore dlpConfigurationStore) {
        dlpConfigurationStore.store(Domain.LOCALHOST, DLPFixture.RULE, new DLPConfigurationItem[0]);
        dlpConfigurationStore.store(Domain.LOCALHOST, DLPFixture.RULE_UPDATED, new DLPConfigurationItem[0]);
        Assertions.assertThat((Iterable)((Iterable)Mono.from((Publisher)dlpConfigurationStore.list(Domain.LOCALHOST)).block())).containsOnly((Object[])new DLPConfigurationItem[]{DLPFixture.RULE_UPDATED});
    }

    @Test
    default public void storingSameRuleShouldBeIdempotent(DLPConfigurationStore dlpConfigurationStore) {
        dlpConfigurationStore.store(Domain.LOCALHOST, DLPFixture.RULE, new DLPConfigurationItem[0]);
        dlpConfigurationStore.store(Domain.LOCALHOST, DLPFixture.RULE, new DLPConfigurationItem[0]);
        Assertions.assertThat((Iterable)((Iterable)Mono.from((Publisher)dlpConfigurationStore.list(Domain.LOCALHOST)).block())).containsOnly((Object[])new DLPConfigurationItem[]{DLPFixture.RULE});
    }

    @Test
    default public void storeShouldClearRulesWhenEmpty(DLPConfigurationStore dlpConfigurationStore) {
        dlpConfigurationStore.store(Domain.LOCALHOST, DLPFixture.RULE, new DLPConfigurationItem[0]);
        dlpConfigurationStore.store(Domain.LOCALHOST, new DLPRules(ImmutableList.of()));
        Assertions.assertThat((Iterable)((Iterable)Mono.from((Publisher)dlpConfigurationStore.list(Domain.LOCALHOST)).block())).isEmpty();
    }
}

