/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.dlp.api;

import java.util.Optional;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.dlp.api.DLPConfigurationItem;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.Test;

public class DLPConfigurationItemTest {
    private static final String EXPLANATION = "explanation";
    private static final String REGEX = "regex";
    public static final DLPConfigurationItem.Id UNIQUE_ID = DLPConfigurationItem.Id.of((String)"uniqueId");

    @Test
    void shouldMatchBeanContract() {
        EqualsVerifier.forClass(DLPConfigurationItem.class).withNonnullFields(new String[]{"regexp"}).verify();
    }

    @Test
    void innerClassTargetsShouldMatchBeanContract() {
        EqualsVerifier.forClass(DLPConfigurationItem.Targets.class).verify();
    }

    @Test
    void innerClassIdShouldMatchBeanContract() {
        EqualsVerifier.forClass(DLPConfigurationItem.Targets.class).verify();
    }

    @Test
    void idShouldThrowOnNull() {
        Assertions.assertThatThrownBy(() -> DLPConfigurationItem.Id.of(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void idShouldThrowOnEmpty() {
        Assertions.assertThatThrownBy(() -> DLPConfigurationItem.Id.of((String)"")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void idShouldThrowOnBlank() {
        Assertions.assertThatThrownBy(() -> DLPConfigurationItem.Id.of((String)"   ")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void idShouldBeMandatory() {
        Assertions.assertThatThrownBy(() -> DLPConfigurationItem.builder().expression("my expression").targetsRecipients().targetsSender().targetsContent().explanation(EXPLANATION).build()).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void expressionShouldBeMandatory() {
        Assertions.assertThatThrownBy(() -> DLPConfigurationItem.builder().id(UNIQUE_ID).targetsRecipients().targetsSender().targetsContent().explanation(EXPLANATION).build()).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void expressionAndIdShouldBeTheOnlyMandatoryFields() {
        Assertions.assertThatCode(() -> DLPConfigurationItem.builder().id(UNIQUE_ID).expression(REGEX).build()).doesNotThrowAnyException();
    }

    @Test
    void hashCodeShouldBeEqualForSimilarRules() {
        Assertions.assertThat((int)DLPConfigurationItem.builder().id(UNIQUE_ID).expression(REGEX).build().hashCode()).isEqualTo(DLPConfigurationItem.builder().id(UNIQUE_ID).expression(REGEX).build().hashCode());
    }

    @Test
    void expressionShouldBeValidPattern() {
        Assertions.assertThatThrownBy(() -> DLPConfigurationItem.builder().id(UNIQUE_ID).expression("*").build()).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void builderShouldPreserveExpression() {
        DLPConfigurationItem dlpConfigurationItem = DLPConfigurationItem.builder().id(UNIQUE_ID).expression(REGEX).build();
        Assertions.assertThat((String)dlpConfigurationItem.getRegexp().pattern()).isEqualTo(REGEX);
    }

    @Test
    void builderShouldPreserveExplanation() {
        DLPConfigurationItem dlpConfigurationItem = DLPConfigurationItem.builder().id(UNIQUE_ID).explanation(EXPLANATION).expression(REGEX).build();
        Assertions.assertThat((Optional)dlpConfigurationItem.getExplanation()).contains((Object)EXPLANATION);
    }

    @Test
    void dlpRuleShouldHaveNoTargetsWhenNoneSpecified() {
        DLPConfigurationItem dlpConfigurationItem = DLPConfigurationItem.builder().id(UNIQUE_ID).expression(REGEX).build();
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(dlpConfigurationItem.getTargets().isContentTargeted()).isFalse();
            softly.assertThat(dlpConfigurationItem.getTargets().isRecipientTargeted()).isFalse();
            softly.assertThat(dlpConfigurationItem.getTargets().isSenderTargeted()).isFalse();
            softly.assertThat(dlpConfigurationItem.getTargets().list()).isEmpty();
        });
    }

    @Test
    void targetsRecipientsShouldBeReportedInTargets() {
        DLPConfigurationItem dlpConfigurationItem = DLPConfigurationItem.builder().id(UNIQUE_ID).targetsRecipients().expression(REGEX).build();
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(dlpConfigurationItem.getTargets().isContentTargeted()).isFalse();
            softly.assertThat(dlpConfigurationItem.getTargets().isRecipientTargeted()).isTrue();
            softly.assertThat(dlpConfigurationItem.getTargets().isSenderTargeted()).isFalse();
            softly.assertThat(dlpConfigurationItem.getTargets().list()).contains((Object[])new DLPConfigurationItem.Targets.Type[]{DLPConfigurationItem.Targets.Type.Recipient});
        });
    }

    @Test
    void targetsSenderShouldBeReportedInTargets() {
        DLPConfigurationItem dlpConfigurationItem = DLPConfigurationItem.builder().id(UNIQUE_ID).targetsSender().expression(REGEX).build();
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(dlpConfigurationItem.getTargets().isContentTargeted()).isFalse();
            softly.assertThat(dlpConfigurationItem.getTargets().isRecipientTargeted()).isFalse();
            softly.assertThat(dlpConfigurationItem.getTargets().isSenderTargeted()).isTrue();
            softly.assertThat(dlpConfigurationItem.getTargets().list()).contains((Object[])new DLPConfigurationItem.Targets.Type[]{DLPConfigurationItem.Targets.Type.Sender});
        });
    }

    @Test
    void targetsContentShouldBeReportedInTargets() {
        DLPConfigurationItem dlpConfigurationItem = DLPConfigurationItem.builder().id(UNIQUE_ID).targetsContent().expression(REGEX).build();
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(dlpConfigurationItem.getTargets().isContentTargeted()).isTrue();
            softly.assertThat(dlpConfigurationItem.getTargets().isRecipientTargeted()).isFalse();
            softly.assertThat(dlpConfigurationItem.getTargets().isSenderTargeted()).isFalse();
            softly.assertThat(dlpConfigurationItem.getTargets().list()).contains((Object[])new DLPConfigurationItem.Targets.Type[]{DLPConfigurationItem.Targets.Type.Content});
        });
    }

    @Test
    void allTargetsShouldBeReportedInTargets() {
        DLPConfigurationItem dlpConfigurationItem = DLPConfigurationItem.builder().id(UNIQUE_ID).targetsContent().targetsSender().targetsRecipients().expression(REGEX).build();
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(dlpConfigurationItem.getTargets().isContentTargeted()).isTrue();
            softly.assertThat(dlpConfigurationItem.getTargets().isRecipientTargeted()).isTrue();
            softly.assertThat(dlpConfigurationItem.getTargets().isSenderTargeted()).isTrue();
            softly.assertThat(dlpConfigurationItem.getTargets().list()).contains((Object[])new DLPConfigurationItem.Targets.Type[]{DLPConfigurationItem.Targets.Type.Content, DLPConfigurationItem.Targets.Type.Sender, DLPConfigurationItem.Targets.Type.Recipient});
        });
    }
}

